/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.Category;
import simplenlg.realiser.CoordinateStringPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;

public class StringPhraseSpec
extends PhraseSpec {
    String spec;
    boolean plural;

    public StringPhraseSpec() {
        this.category = null;
        this.spec = null;
        this.plural = false;
    }

    public StringPhraseSpec(String spec) {
        this();
        this.spec = spec;
    }

    public StringPhraseSpec(String spec, Category cat) {
        this(spec);
        this.category = cat;
    }

    public String getString() {
        return this.spec;
    }

    public void setCategory(Category c) {
        this.category = c;
    }

    public void setPlural(boolean plur) {
        this.plural = plur;
    }

    public boolean isPlural() {
        return this.plural;
    }

    @Override
    String realise(Realiser r) {
        return this.spec;
    }

    public boolean equals(Object o) {
        try {
            StringPhraseSpec sps = (StringPhraseSpec)o;
            if (this.spec != null && sps.spec != null) {
                return sps.spec.equals(this.spec) && sps.category == this.category;
            }
            return sps.spec == this.spec && sps.category == this.category;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public StringPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateStringPhraseSpec coord = new CoordinateStringPhraseSpec(this);
        try {
            for (Phrase p : coords) {
                coord.addCoordinates((StringPhraseSpec)p);
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    public String toString() {
        return "(StringPhraseSpec " + this.spec + ")";
    }
}

