/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import simplenlg.features.AdverbPosition;
import simplenlg.features.AdverbType;
import simplenlg.features.Category;
import simplenlg.features.Polarity;
import simplenlg.lexicon.lexicalitems.ContentWord;

public class Adverb
extends ContentWord {
    Set<AdverbPosition> positions = new HashSet<AdverbPosition>();
    Set<AdverbType> adverbTypes = new HashSet<AdverbType>();
    Polarity polarity;

    public Adverb(String baseform) {
        super(baseform);
        this.category = Category.ADVERB;
        this.polarity = Polarity.POSITIVE;
    }

    public Adverb(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Adverb(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Collection<AdverbPosition> getPositions() {
        return this.positions;
    }

    public void setPositions(Collection<AdverbPosition> pos) {
        this.positions.clear();
        this.positions.addAll(pos);
    }

    public void addPosition(AdverbPosition pos) {
        this.positions.add(pos);
    }

    public boolean hasPosition(AdverbPosition position) {
        return this.positions.contains(position);
    }

    public Collection<AdverbType> getAdverbTypes() {
        return this.adverbTypes;
    }

    public void setAdverbTypes(Collection<AdverbType> types) {
        this.adverbTypes.clear();
        this.adverbTypes.addAll(types);
    }

    public void addAdverbType(AdverbType type) {
        this.adverbTypes.add(type);
    }

    public boolean hasType(AdverbType type) {
        return this.adverbTypes.contains(type);
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    public void setPolarity(Polarity polarity) {
        this.polarity = polarity;
    }
}

