/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.pennchinese.ChineseTreebankLanguagePack;
import java.util.ArrayList;

public class ChineseCollinizer
implements TreeTransformer {
    private static final boolean VERBOSE = false;
    private final boolean deletePunct;
    ChineseTreebankLanguagePack ctlp;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public ChineseCollinizer(ChineseTreebankLanguagePack ctlp) {
        this(ctlp, true);
    }

    public ChineseCollinizer(ChineseTreebankLanguagePack ctlp, boolean deletePunct) {
        this.deletePunct = deletePunct;
        this.ctlp = ctlp;
    }

    @Override
    public Tree transformTree(Tree tree) {
        return this.transformTree(tree, true);
    }

    private Tree transformTree(Tree tree, boolean isRoot) {
        String label = tree.label().value();
        if (tree.isLeaf()) {
            if (this.deletePunct && this.ctlp.isPunctuationWord(label)) {
                return null;
            }
            return this.tf.newLeaf(new StringLabel(label));
        }
        if (tree.isPreTerminal() && this.deletePunct && this.ctlp.isPunctuationTag(label)) {
            return null;
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        if (label.matches("ROOT.*") && tree.numChildren() == 1) {
            return this.transformTree(tree.children()[0], true);
        }
        label = label.replaceFirst("[^A-Z].*$", "");
        label = label.replaceFirst("PRN", "ADVP");
        for (int cNum = 0; cNum < tree.children().length; ++cNum) {
            Tree child = tree.children()[cNum];
            Tree newChild = this.transformTree(child, false);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty() && !isRoot) {
            return null;
        }
        return this.tf.newTreeNode(new StringLabel(label), children);
    }
}

