/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.parser.metrics.AbstractEval;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFilters;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.util.Set;

public class FilteredEval
extends AbstractEval {
    Filter<Tree> subtreeFilter;
    private final ConstituentFactory cf = new LabeledScoredConstituentFactory();

    public FilteredEval(String str, boolean runningAverages, Filter<Tree> subtreeFilter) {
        super(str, runningAverages);
        this.subtreeFilter = subtreeFilter;
    }

    @Override
    protected Set<?> makeObjects(Tree tree) {
        Set<Constituent> set = Generics.newHashSet();
        if (tree != null) {
            set.addAll(tree.constituents(this.cf, false, this.subtreeFilter));
        }
        return set;
    }

    public static FilteredEval childFilteredEval(String str, boolean runningAverages, TreebankLanguagePack tlp, String childPattern) {
        return new FilteredEval(str, runningAverages, new TreeFilters.HasMatchingChild(tlp, childPattern));
    }
}

