/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class ByteKeyAnalyzer
extends AbstractKeyAnalyzer<Byte>
implements Serializable {
    private static final long serialVersionUID = -5294514513354687850L;
    public static final ByteKeyAnalyzer INSTANCE = new ByteKeyAnalyzer();
    private static final int MSB = 128;

    private static int mask(int n) {
        return 128 >>> n;
    }

    @Override
    public int lengthInBits(Byte by) {
        return 8;
    }

    @Override
    public boolean isBitSet(Byte by, int n) {
        return (by & ByteKeyAnalyzer.mask(n)) != 0;
    }

    @Override
    public int bitIndex(Byte by, Byte by2) {
        byte by3 = by;
        if (by3 == 0) {
            return -1;
        }
        byte by4 = by2;
        if (by3 != by4) {
            int n = by3 ^ by4;
            for (int i = 0; i < 8; ++i) {
                if ((n & ByteKeyAnalyzer.mask(i)) == 0) continue;
                return i;
            }
        }
        return -2;
    }

    @Override
    public boolean isPrefix(Byte by, Byte by2) {
        return by.equals(by2);
    }
}

