/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.treesegs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matetools.is2.data.Cluster;
import matetools.is2.data.DataFES;
import matetools.is2.data.F2SF;
import matetools.is2.data.Instances;
import matetools.is2.data.Parse;
import matetools.is2.data.PipeGen;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.io.CONLLWriter09;
import matetools.is2.modification.io.CONLLReader08;
import matetools.is2.modification.treesegs.RandomTreeSegmentation;
import matetools.is2.modification.treesegs.TreeSegmentation;
import matetools.is2.modification.treesegs.TreeSegmentsExtractor;
import matetools.is2.modification.treesegs.TreeSegmentsParallelExtract;
import matetools.is2.parser.Edges;
import matetools.is2.parser.MFO;
import matetools.is2.parser.Parser;
import matetools.is2.util.DB;
import matetools.is2.util.OptionsSuper;

public class TreeSegmentsPipe
extends PipeGen {
    public TreeSegmentation treeSeg;
    public TreeSegmentsExtractor[] extractor;
    public final MFO mf = new MFO();
    public Cluster cl;
    protected OptionsSuper options;
    public static long timeExtract;
    public static ExecutorService executerService;

    static {
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
    }

    public TreeSegmentsPipe(OptionsSuper o) {
        this.options = o;
    }

    public void createInstances(String file, Instances is) throws Exception {
        CONLLReader09 depReader = this.options.formatTask == 9 ? new CONLLReader09(file) : new CONLLReader08(file);
        this.mf.register("REL", "<root-type>");
        long sl = 0L;
        System.out.print("Registering feature parts of sentence: ");
        int ic = 0;
        int del = 0;
        Iterator<SentenceData09> treeSegs = this.treeSeg.segment(depReader.getNext()).iterator();
        ArrayList<SentenceData09> sents = new ArrayList<SentenceData09>();
        CONLLWriter09 depWriter = new CONLLWriter09(String.valueOf(this.options.trainfile) + ".segs");
        do {
            if (!treeSegs.hasNext()) {
                SentenceData09 sent = depReader.getNext();
                if (sent == null) {
                    depWriter.finishWriting();
                    break;
                }
                treeSegs = this.treeSeg.segment(sent).iterator();
            }
            SentenceData09 instance = treeSegs.next();
            depWriter.write(RandomTreeSegmentation.toSegmentSent(instance));
            sents.add(instance);
            sl += (long)instance.labels.length;
            if (++ic % 1000 == 0) {
                del = TreeSegmentsPipe.outValue(ic, del);
            }
            String[] labs1 = instance.labels;
            int i1 = 0;
            while (i1 < labs1.length) {
                this.mf.register("REL", labs1[i1]);
                ++i1;
            }
            String[] w = instance.forms;
            int i12 = 0;
            while (i12 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i12]));
                ++i12;
            }
            w = instance.plemmas;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i12]));
                ++i12;
            }
            w = instance.ppos;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("POS", w[i12]);
                ++i12;
            }
            w = instance.gpos;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("POS", w[i12]);
                ++i12;
            }
            if (instance.feats == null) continue;
            String[][] fs = instance.feats;
            int i13 = 0;
            while (i13 < fs.length) {
                w = fs[i13];
                if (w != null) {
                    int i2 = 0;
                    while (i2 < w.length) {
                        this.mf.register("F", w[i2]);
                        ++i2;
                    }
                }
                ++i13;
            }
        } while (ic - 1 <= this.options.count);
        del = TreeSegmentsPipe.outValue(ic, del);
        System.out.println();
        TreeSegmentsExtractor.initFeatures();
        TreeSegmentsExtractor.maxForm = this.mf.getFeatureCounter().get("WORD");
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, this.mf, 6);
        this.mf.calculateBits();
        TreeSegmentsExtractor.initStat(this.options.featureCreation);
        System.out.println(this.mf.toString());
        TreeSegmentsExtractor[] fs = this.extractor;
        int w = this.extractor.length;
        int labs1 = 0;
        while (labs1 < w) {
            TreeSegmentsExtractor e = fs[labs1];
            e.init();
            ++labs1;
        }
        treeSegs = sents.iterator();
        int num1 = 0;
        is.init(ic, new MFO());
        Edges.init(this.mf.getFeatureCounter().get("POS"));
        System.out.print("Creating edge filters and read corpus: ");
        del = 0;
        while (true) {
            if (num1 % 100 == 0) {
                del = TreeSegmentsPipe.outValue(num1, del);
            }
            if (!treeSegs.hasNext()) break;
            SentenceData09 instance1 = treeSegs.next();
            this.insert(is, instance1);
            if (instance1 == null) break;
            int last = is.size() - 1;
            short[] pos = is.pposs[last];
            is.originalPosition[last] = instance1.originalPosition;
            int k = 0;
            while (k < is.lengthOfHeads(last)) {
                if (is.heads[last][k] >= 0) {
                    Edges.put(pos[is.originalPosition[last][is.heads[last][k]]], pos[is.originalPosition[last][k]], is.labels[last][is.originalPosition[last][k]]);
                }
                ++k;
            }
            if (!this.options.allFeatures && num1 > this.options.count) break;
            ++num1;
        }
        del = TreeSegmentsPipe.outValue(num1, del);
        System.out.println();
        Edges.findDefault();
    }

    public boolean insert(Instances is, SentenceData09 it) {
        CONLLReader09 reader = new CONLLReader09();
        String US = "_";
        int i = is.createInstance09(it.length());
        is.heads[i] = new short[it.heads.length];
        int p = 0;
        while (p < it.length()) {
            is.setForm(i, p, reader.normalize(it.forms[p]));
            is.setGPos(i, p, it.gpos[p]);
            if (it.ppos[p] == null || it.ppos[p].equals(US)) {
                is.setPPoss(i, p, it.gpos[p]);
            } else {
                is.setPPoss(i, p, it.ppos[p]);
            }
            if (it.plemmas[p] == null || it.plemmas[p].equals(US)) {
                is.setLemma(i, p, reader.normalize(it.forms[p]));
            } else {
                is.setLemma(i, p, reader.normalize(it.plemmas[p]));
            }
            if (it.lemmas != null) {
                if (it.lemmas[p] == null) {
                    is.setGLemma(i, p, it.plemmas[p]);
                } else {
                    is.setGLemma(i, p, it.lemmas[p]);
                }
            }
            if (it.feats != null && it.feats[p] != null) {
                is.setFeats(i, p, it.feats[p]);
            }
            if (it.ofeats != null) {
                is.setFeature(i, p, it.ofeats[p]);
            }
            if (it.pfeats != null) {
                is.setPFeature(i, p, it.pfeats[p]);
            }
            if (it.pheads != null) {
                is.setPHead(i, p, it.pheads[p]);
            }
            is.setRel(i, p, it.labels[p]);
            if (it.plabels != null) {
                is.setPRel(i, p, it.plabels[p]);
            }
            if (it.fillp != null && it.fillp[p] != null && it.fillp[p].startsWith("Y")) {
                is.pfill[i].set(p);
            } else {
                is.pfill[i].clear(p);
            }
            ++p;
        }
        p = 0;
        while (p < it.heads.length) {
            is.setHead(i, p, it.heads[p]);
            ++p;
        }
        if (is.createSem(i, it)) {
            DB.println("count " + i + " len " + it.length());
            DB.println(it.printSem());
        }
        return true;
    }

    protected final SentenceData09 nextInstance(Instances is, CONLLReader09 depReader) throws Exception {
        SentenceData09 instance = depReader.getNext(is);
        if (instance == null || instance.forms == null) {
            return null;
        }
        return instance;
    }

    public DataFES fillVector(F2SF params, Instances is, int inst, DataFES d, Cluster cluster) throws InterruptedException {
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int length = is.lengthOfHeads(inst);
        if (d == null || d.len < length) {
            d = new DataFES(length, this.mf.getFeatureCounter().get("REL").shortValue());
        }
        ArrayList<TreeSegmentsParallelExtract> pe = new ArrayList<TreeSegmentsParallelExtract>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new TreeSegmentsParallelExtract(this.extractor[i], is, inst, d, (F2SF)params.clone(), cluster));
            ++i;
        }
        int w1 = 0;
        while (w1 < length) {
            int w2 = w1 + 1;
            while (w2 < length) {
                if (w1 != w2) {
                    TreeSegmentsParallelExtract.add(w1, w2);
                }
                ++w2;
            }
            ++w1;
        }
        executerService.invokeAll(pe);
        timeExtract += System.nanoTime() - ts;
        return d;
    }

    public double errors(Instances is, int ic, Parse p) {
        short[] act = is.heads[ic];
        double correct = 0.0;
        int i = 1;
        while (i < act.length) {
            if (p.heads[i] == act[i]) {
                correct += 0.5;
                if (p.labels[i] == is.labels[ic][i]) {
                    correct += 0.5;
                }
            }
            ++i;
        }
        double x = (double)act.length - 1.0 - correct;
        p.f1 = correct / (double)(act.length - 1);
        return x;
    }
}

