/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.Value;
import fig.servlet.ValueProcessor;

public abstract class Field
implements Comparable {
    public String name;
    public String displayName;
    public String gloss;
    public boolean numeric;
    public boolean mutable;
    public boolean multiline;
    public boolean hidden;
    public int width;
    public int rank;
    public ValueProcessor processor;

    public Field(String name, String displayName, String gloss) {
        this.name = name;
        this.displayName = displayName;
        this.gloss = gloss;
    }

    public abstract Value getValue(Item var1) throws MyException;

    public void changeValue(Item item, String newValue) throws MyException {
        throw MyExceptions.unsupported("changeValue", "field " + this.name);
    }

    public Value processValue(Value value) {
        return this.processor == null ? value : new Value(this.processor.process(value.value), value.cmpKey);
    }

    public Field setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public Field setNumeric(boolean numeric) {
        this.numeric = numeric;
        return this;
    }

    public int compareTo(Object o) {
        Field f = (Field)o;
        if (this.rank < f.rank) {
            return -1;
        }
        if (this.rank > f.rank) {
            return 1;
        }
        return 0;
    }
}

