/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import java.util.Arrays;
import java.util.LinkedHashSet;

public class BipartiteMatcher {
    private double[][] copy(double[][] matrix) {
        double[][] newMatrix = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                newMatrix[i][j] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return newMatrix;
    }

    public int[] findMaxWeightAssignment(double[][] matrix) {
        matrix = this.copy(matrix);
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = -matrix[i][j];
                ++j;
            }
            ++i;
        }
        return this.findBestAssignment(matrix);
    }

    public int[] findMinWeightAssignment(double[][] matrix) {
        matrix = this.copy(matrix);
        return this.findBestAssignment(matrix);
    }

    private int[] findBestAssignment(double[][] matrix) {
        this.reduceMatrix(matrix);
        int[] starsByRow = new int[matrix.length];
        Arrays.fill(starsByRow, -1);
        int[] starsByCol = new int[matrix[0].length];
        Arrays.fill(starsByCol, -1);
        int[] primesByRow = new int[matrix.length];
        Arrays.fill(primesByRow, -1);
        int[] coveredRows = new int[matrix.length];
        int[] coveredCols = new int[matrix[0].length];
        this.initStars(matrix, starsByRow, starsByCol);
        this.coverColumnsOfStarredZeroes(starsByCol, coveredCols);
        while (!this.allAreCovered(coveredCols)) {
            int[] primedZero = this.primeSomeUncoveredZero(matrix, primesByRow, coveredRows, coveredCols);
            while (primedZero == null) {
                this.makeMoreZeroes(matrix, coveredRows, coveredCols);
                primedZero = this.primeSomeUncoveredZero(matrix, primesByRow, coveredRows, coveredCols);
            }
            int columnIndex = starsByRow[primedZero[0]];
            if (-1 == columnIndex) {
                this.incrementSetOfStarredZeroes(primedZero, starsByRow, starsByCol, primesByRow);
                Arrays.fill(primesByRow, -1);
                Arrays.fill(coveredRows, 0);
                Arrays.fill(coveredCols, 0);
                this.coverColumnsOfStarredZeroes(starsByCol, coveredCols);
                continue;
            }
            coveredRows[primedZero[0]] = 1;
            coveredCols[columnIndex] = 0;
        }
        int[] assign = new int[starsByCol.length];
        int i = 0;
        while (i < starsByCol.length) {
            assign[starsByCol[i]] = i;
            ++i;
        }
        return assign;
    }

    private boolean allAreCovered(int[] coveredCols) {
        int[] nArray = coveredCols;
        int n = coveredCols.length;
        int n2 = 0;
        while (n2 < n) {
            int covered = nArray[n2];
            if (covered == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void reduceMatrix(double[][] matrix) {
        int j;
        int i = 0;
        while (i < matrix.length) {
            double minValInRow = Double.MAX_VALUE;
            j = 0;
            while (j < matrix[i].length) {
                if (minValInRow > matrix[i][j]) {
                    minValInRow = matrix[i][j];
                }
                ++j;
            }
            j = 0;
            while (j < matrix[i].length) {
                double[] dArray = matrix[i];
                int n = j++;
                dArray[n] = dArray[n] - minValInRow;
            }
            ++i;
        }
        i = 0;
        while (i < matrix[0].length) {
            double minValInCol = Double.MAX_VALUE;
            j = 0;
            while (j < matrix.length) {
                if (minValInCol > matrix[j][i]) {
                    minValInCol = matrix[j][i];
                }
                ++j;
            }
            j = 0;
            while (j < matrix.length) {
                double[] dArray = matrix[j];
                int n = i;
                dArray[n] = dArray[n] - minValInCol;
                ++j;
            }
            ++i;
        }
    }

    private void initStars(double[][] costMatrix, int[] starsByRow, int[] starsByCol) {
        int[] rowHasStarredZero = new int[costMatrix.length];
        int[] colHasStarredZero = new int[costMatrix[0].length];
        int i = 0;
        while (i < costMatrix.length) {
            int j = 0;
            while (j < costMatrix[i].length) {
                if (0.0 == costMatrix[i][j] && rowHasStarredZero[i] == 0 && colHasStarredZero[j] == 0) {
                    starsByRow[i] = j;
                    starsByCol[j] = i;
                    rowHasStarredZero[i] = 1;
                    colHasStarredZero[j] = 1;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void coverColumnsOfStarredZeroes(int[] starsByCol, int[] coveredCols) {
        int i = 0;
        while (i < starsByCol.length) {
            coveredCols[i] = -1 == starsByCol[i] ? 0 : 1;
            ++i;
        }
    }

    private int[] primeSomeUncoveredZero(double[][] matrix, int[] primesByRow, int[] coveredRows, int[] coveredCols) {
        int i = 0;
        while (i < matrix.length) {
            if (1 != coveredRows[i]) {
                int j = 0;
                while (j < matrix[i].length) {
                    if (0.0 == matrix[i][j] && coveredCols[j] == 0) {
                        primesByRow[i] = j;
                        return new int[]{i, j};
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private void incrementSetOfStarredZeroes(int[] unpairedZeroPrime, int[] starsByRow, int[] starsByCol, int[] primesByRow) {
        int i;
        int j = unpairedZeroPrime[1];
        LinkedHashSet<int[]> zeroSequence = new LinkedHashSet<int[]>();
        zeroSequence.add(unpairedZeroPrime);
        boolean paired = false;
        do {
            boolean bl = paired = -1 != (i = starsByCol[j]) && zeroSequence.add(new int[]{i, j});
        } while (paired && (paired = -1 != (j = primesByRow[i]) && zeroSequence.add(new int[]{i, j})));
        for (int[] zero : zeroSequence) {
            if (starsByCol[zero[1]] == zero[0]) {
                starsByCol[zero[1]] = -1;
                starsByRow[zero[0]] = -1;
            }
            if (primesByRow[zero[0]] != zero[1]) continue;
            starsByRow[zero[0]] = zero[1];
            starsByCol[zero[1]] = zero[0];
        }
    }

    private void makeMoreZeroes(double[][] matrix, int[] coveredRows, int[] coveredCols) {
        int j;
        double minUncoveredValue = Double.MAX_VALUE;
        int i = 0;
        while (i < matrix.length) {
            if (coveredRows[i] == 0) {
                j = 0;
                while (j < matrix[i].length) {
                    if (coveredCols[j] == 0 && matrix[i][j] < minUncoveredValue) {
                        minUncoveredValue = matrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < coveredRows.length) {
            if (1 == coveredRows[i]) {
                j = 0;
                while (j < matrix[i].length) {
                    double[] dArray = matrix[i];
                    int n = j++;
                    dArray[n] = dArray[n] + minUncoveredValue;
                }
            }
            ++i;
        }
        i = 0;
        while (i < coveredCols.length) {
            if (coveredCols[i] == 0) {
                j = 0;
                while (j < matrix.length) {
                    double[] dArray = matrix[j];
                    int n = i;
                    dArray[n] = dArray[n] - minUncoveredValue;
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        double[][] mat = new double[][]{{3.0, 3.0, 0.0}, {3.0, 3.0, 0.0}, {0.0, 5.0, 0.0}};
        int[] assign = new BipartiteMatcher().findBestAssignment(mat);
        int i = 0;
        while (i < assign.length) {
            System.out.println(String.valueOf(i) + " => " + assign[i]);
            ++i;
        }
    }
}

