///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <sstream>
#include "nl-cpt.h"
#include "nl-dtree.h"

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////
/* Moved to HHMMLangModel-trace.h because of complicated dependencies */

////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

class WModel;

//// Preterminal (POS) given constituent category models...

int OModel::word_num = -1;
Wd OModel::curWord;

void OModel::calcProb ( OModel::RandVarType& o, const Wd& w) const
{
    o.clear();
    
    for ( PgivGModel::const_iterator iter = modPgivG.begin(); iter!=modPgivG.end(); iter++ ) {
      G g = iter->first.getX1();
      P::ArrayIterator<LogProb> p;
      int aCtr=-1;
      //for ( bool bp=modPgivG.setIterProb(p,g,aCtr); bp; bp=modPgivG.setIterProb(p,g,aCtr=0) ) {
      for (LogProb pr=modPgivG.setIterProb(p,g,aCtr); pr!=LogProb(); pr = modPgivG.setIterProb(p,g,aCtr=0) ){
        // Take care of the ip = IP_F case (no interruption point)
        o.setProb(g) += modPgivG.getProb(p,g).toProb() * modWgivP.getProb(w,p,word_num).toProb();
        // ip = IP_T case
        //o.setProb(IPGKey(I_ALT,g)) += modPgivG.getProb(p,g).toProb() * modWgivP.getBufProb(w,p,word_num).toProb();
      }
    }
}

LogProb WModel::getProb ( const Wd& w, const P::ArrayIterator<LogProb>& p, int loc) const
{
    assert(modP.getProb(p)!=LogProb());
    // p(w | p) = p (p | w) * p(w) / p(p)
    // in unk case, we use decision tree for p(p | w) and make up a prob for unknown
    // this will slightly screw up probs. since W prior doesn't take into acct unk.
    LogProb pr = ( modW.contains(w) ? 
                                    (modPgivWs.getProb(p,w) * modW.getProb(w)) : (modPgivWdt.getProb(p,w)) * LogProb(0.01))
                                     / modP.getProb(p) ;
//                                    : modWunkgivP.getProb(w,p,loc,modW) );
    return pr;
}


// from shriberg - icslp 96:
// normalized version of p(i) = 1.22 * 0.45^i
//float buf_params[] = {0.57, 0.26, 0.12, 0.05};

/*
LogProb WModel::getBufProb ( const Word& w, const P::ArrayIterator<LogProb>& p, int loc) const
{
    // smoothing parameter for the buffer
    float buf_alpha = 0.75; // the best found so far...
    Prob buf_prob = 0.0;
    
    Prob baseline = getProb(Wd(w.getString().c_str()),p,loc).toProb();
//    return LogProb(baseline);
    // If this POS can't generate this word, don't force it.
    if(baseline == 0.0){
      return LogProb(baseline);
    }
    
    // See if it's in the buffer
    for(int i =0; i < bufferSize; i++){
      if(OModel::wBuf.get(i) == w){
//        buf_prob = 1.0 / (float) bufferSize;
        buf_prob = buf_params[i];
        break;
      }
    }
    
    Prob retVal = buf_alpha * buf_prob + (1-buf_alpha) * baseline;
    assert(retVal.toDouble() >= 0.0 && retVal.toDouble() <= 1.0);
//    if(buf_prob > 0.0){
//      cerr << "Found the word: " << w << " in the buffer, returning probability:" << retVal << endl;
//    }
    return LogProb(retVal);
}
*/
typedef Wd W;
