
import re
import sys
from model import Model, CondModel

# obtain corpus and category counts
ls = []
dc = Model()
for s in sys.stdin:
    ls.append(s)
    for c in re.findall('\([^ ()]+',s):
        dc[c] += 1.0

# test if no rare cats
def no_rare_cats ( s ):
    for c in re.findall('\([^ ()]+',s):
        if dc[c]==1:
            sys.stderr.write('elim rare cat: '+c+'\n')
            return False
    return True

# print trees with no rare cats
for s in ls:
    if no_rare_cats(s):
        sys.stdout.write(s)
