import torch
import torch.nn as nn
from tqdm import tqdm
from torch.autograd import Variable
from batch_generator import *
from torch.nn.utils.rnn import pack_padded_sequence, pad_packed_sequence
import time
from itertools import chain
from custom_rnn import *

# Hyper Parameters
embedding_size = 300
context_size = 600
affine_size = 150
maxlen = 300
channel_size = 75
compress_size = 150
kernel_size = 3
layer_size = 9
num_classes = 10
batch_size = 128
iter_size = 64
iter_num = batch_size // iter_size
num_epochs = 2
init_learning_rate = [0.001, 0.001, 0.001]
device = torch.device('cuda:0')


# train_filename='imdb_tr.pkl'
# test_filename='imdb_te.pkl'
# dic_filename='imdb_dic.pkl'

def get_maxlen(df_name):
    df = load_file(df_name)
    ls = df['len'].tolist()
    ls = [sum(l) for l in ls]
    return max(ls)


train_filename = 'data/text_classification/yahoo/allen/train.pkl'
test_filename = 'data/text_classification/yahoo/allen/test.pkl'
dic_filename = 'data/text_classification/yahoo/allen/dictionary.pkl'
# glove_filename = None
glove_filename = 'data/text_classification/yahoo/allen/glove.pkl'

dic = load_file(dic_filename)
trdf = load_file(train_filename)
tedf = load_file(test_filename)
tr = BucketedDataIterator(trdf, dic, 20, char_embedding=False, max_len=maxlen)
te = BucketedDataIterator(tedf, dic, char_embedding=False, oov_index=tr.oov_index, max_len=maxlen)
vocab_size = tr.oov_index + 1


# maxlen = get_maxlen(train_filename)


def adjust_learning_rate(optimizer, lr):
    for param_group in optimizer.param_groups:
        param_group['lr'] = lr
    return optimizer


# class Dynamic_FC(nn.Module):
#     def __init__(self, context_size,infilter_size,maxlen, num_classes):
#         super(Dynamic_Conv, self).__init__()
#         self.context_size = context_size
#         self.infilter_size = infilter_size
#         self.outfilter_size = outfilter_size
#         self.kernel_size = kernel_size
#         self.padding_size = int((kernel_size - 1) / 2)
#         # self.gamma = Parameter(torch.ones(layer_size))
#         # self.beta = Parameter(torch.zeros(layer_size))
#         conv_dims = outfilter_size * infilter_size * kernel_size
#         self.std_conv = math.sqrt(2 / (outfilter_size + infilter_size * kernel_size))
#         self.convs = nn.Sequential(nn.Linear(context_size,context_size),nn.LeakyReLU(),
#                                             nn.Linear(context_size,conv_dims))
#         self.new_context = nn.Sequential(nn.Linear(conv_dims,context_size),nn.LeakyReLU())
#         self.reset_parameters()
#
#     def reset_parameters(self):
#         for i in self.convs:
#             if isinstance(i,nn.Linear):
#                 nn.init.kaiming_normal_(i.weight)
#                 nn.init.constant_(i.bias,val=0)
#         for i in self.new_context:
#             if isinstance(i,nn.Linear):
#                 nn.init.kaiming_normal_(i.weight)
#                 nn.init.constant_(i.bias,val=0)
#
#     def forward(self,context,x):
#         """
#
#         :param x: [batch, lens, channel]
#         :return: context [batch,context_size], x [batch,lens,channel]
#         """
#         device = x.device
#         batch_size = x.size(0)
#         # print(x.size(),self.context_size,self.weight_size)
#         # temp = F.unfold(x,kernel_size=self.kernel_size,padding=int((self.kernel_size - 1) / 2))
#         temp = x.unfold(1, self.kernel_size, 1).contiguous()
#         if self.padding_size:
#             padding = torch.zeros(batch_size, self.padding_size, self.infilter_size, self.kernel_size).to(device)
#             temp = torch.cat([padding, temp,padding], 1)
#         temp = temp.view(temp.size(0), temp.size(1), -1) #[batch, len, in*k]
#         conv_weight = self.convs(context)
#         mean = conv_weight.mean(-1, keepdim=True)
#         std = conv_weight.std(-1, keepdim=True)
#         conv_weight = (conv_weight -mean / std) * (self.std_conv *2)
#         new_context = self.new_context(conv_weight)
#
#         conv_weight = conv_weight.view(batch_size, self.infilter_size*self.kernel_size, -1)  # [batch, in*k, out]
#         # i = i.view(i.size(0),-1).transpose(0,1)
#         # out = temp @ i
#         # print(temp.size(),conv_weight.size())
#         out = torch.bmm(temp, conv_weight)
#         out = F.leaky_relu(out)
#         return new_context, out

class Dynamic_Conv(nn.Module):
    def __init__(self, context_size, infilter_size, outfilter_size, kernel_size,hash_size=70,rank=5):
        super(Dynamic_Conv, self).__init__()
        self.context_size = context_size
        self.infilter_size = infilter_size
        self.outfilter_size = outfilter_size
        self.kernel_size = kernel_size
        self.padding_size = int((kernel_size - 1) / 2)
        # self.gamma = Parameter(torch.ones(layer_size))
        # self.beta = Parameter(torch.zeros(layer_size))
        self.gru = nn.GRU(infilter_size, context_size // 2, 1, batch_first=True, bidirectional=True)
        # self.latent_trans = nn.Sequential(nn.Linear(context_size, context_size), nn.Tanh())
        self.self_att_vec = Parameter(torch.Tensor(context_size))
        self.att_vec_g = Parameter(torch.Tensor([1.0]))
        conv_dims = outfilter_size * infilter_size * kernel_size
        self.rank = rank
        self.hash_size = hash_size
        self.hash_f = np.random.randint(0, hash_size, size=(outfilter_size, rank))
        self.hash_b = nn.Embedding(hash_size, infilter_size * kernel_size)
        self.std_conv = math.sqrt(1 / (infilter_size * kernel_size))
        # self.convs = nn.Sequential(nn.Linear(context_size, context_size), nn.LeakyReLU(),
        #                            nn.Linear(context_size, conv_dims))
        # self.convs = nn.Sequential(nn.Linear(context_size, conv_dims))
        # self.bias = nn.Sequential(nn.Linear(context_size, outfilter_size))
        self.convs = nn.Sequential(nn.Linear(context_size, outfilter_size * rank))
        # self.generation = nn.Sequential(nn.Linear(rank, infilter_size * kernel_size))
        # self.conv_left = nn.Sequential(nn.Linear(context_size, infilter_size * kernel_size * rank))
        # self.conv_right = nn.Sequential(nn.Linear(context_size, outfilter_size * rank))
        # self.ln = nn.LayerNorm(outfilter_size)
        self.reset_parameters()

    def reset_parameters(self):
        nn.init.kaiming_normal_(self.hash_b.weight, nonlinearity='linear')
        for i in self.convs:
            if isinstance(i, nn.Linear):
                nn.init.kaiming_normal_(i.weight,nonlinearity='relu')
                # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
                nn.init.constant_(i.bias, val=0)
        # for i in self.generation:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight)
        #         # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
        #         nn.init.constant_(i.bias, val=0)
        # for i in self.bias:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight)
        #         # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
        #         nn.init.constant_(i.bias, val=0)
        # for i in self.conv_left:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight)
        #         # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
        #         nn.init.constant_(i.bias, val=0)
        # for i in self.conv_right:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight)
        #         # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
        #         nn.init.constant_(i.bias, val=0)
        # for i in self.latent_trans:
        #     if isinstance(i, nn.Linear):
        #         nn.init.kaiming_normal_(i.weight, nonlinearity='tanh')
        #         nn.init.constant_(i.bias, val=0)
        nn.init.normal_(self.self_att_vec.data, std=1.0 / math.sqrt(self.context_size))
        stdv = math.sqrt(1.0 / (self.infilter_size))
        stdv_1 = math.sqrt(1.0 / self.context_size)
        for name, param in self.gru.named_parameters():
            if 'bias' in name:
                nn.init.constant_(param, val=0)
                # if 'l0' in name:
                #     nn.init.normal_(param, 0, stdv)
                # else:
                #     nn.init.normal_(param, 0, stdv_1)
            elif 'weight' in name:
                if 'l0' in name:
                    # nn.init.xavier_normal_(param)
                    nn.init.normal_(param, 0, stdv)
                else:
                    nn.init.normal_(param, 0, stdv_1)

    def forward(self,x, seq_lengths):
        """
        :param x: [batch, lens, channel]
        :return: context [batch,context_size], x [batch,lens,channel]
        """
        device = x.device
        batch_size = x.size(0)

        # context = F.max_pool1d(x.transpose(1, 2), x.size(1)).squeeze()

        packed_input = pack_padded_sequence(x, seq_lengths, batch_first=True)
        packed_output, _ = self.gru(packed_input, None)
        out_rnn, _ = pad_packed_sequence(packed_output, batch_first=True)
        # out_rnn = self.latent_trans(out_rnn)
        att_vec = self.att_vec_g * (self.self_att_vec / torch.sqrt(torch.sum(self.self_att_vec ** 2)))
        # att_vec = self.self_att_vec
        att_vec = att_vec.unsqueeze(0).unsqueeze(0)
        logits = torch.sum(torch.mul(out_rnn, att_vec), -1)
        att = softmax_with_len(logits, seq_lengths).unsqueeze(-1)  # [b, l]
        context = torch.sum(out_rnn * att, 1)

        # print(x.size(),self.context_size,self.weight_size)
        # temp = F.unfold(x,kernel_size=self.kernel_size,padding=int((self.kernel_size - 1) / 2))
        temp = x.unfold(1, self.kernel_size, 1).contiguous()
        if self.padding_size:
            padding = torch.zeros(batch_size, self.padding_size, self.infilter_size, self.kernel_size).to(device)
            temp = torch.cat([padding, temp, padding], 1)
        temp = temp.view(temp.size(0), temp.size(1), -1)  # [batch, len, in*k]

        # conv_weight = self.convs(context).view(batch_size, -1, self.rank)  # [batch, out * ink, rank]
        # conv_weight = F.softmax(conv_weight, -1).transpose(0,1)
        # hashed = self.hash_b(torch.from_numpy(self.hash_f).to(device))  # [out*ink, rank, in]
        # conv_weight = torch.bmm(conv_weight, hashed)
        # conv_weight = conv_weight.permute(1, 2, 0)
        # conv_weight = conv_weight.contiguous().view(batch_size,self.infilter_size*self.kernel_size,self.outfilter_size)

        conv_weight = self.convs(context).view(batch_size, -1, self.rank)  # [batch, out, rank]
        conv_weight = F.softmax(conv_weight, -1)
        hashed = self.hash_b(torch.from_numpy(self.hash_f).to(device))  # [out, rank, in*k]
        conv_weight = torch.bmm(conv_weight.transpose(0, 1), hashed)  # [ out, batch, in*k]
        conv_weight = conv_weight.permute(1, 2, 0)

        # conv_weight = self.convs(context).view(batch_size, -1, self.rank)  # [batch, out, rank]
        # conv_weight = F.softmax(conv_weight, -1)
        # hashed = self.hash_b(torch.from_numpy(self.hash_f).to(device))
        # conv_weight = torch.mul(conv_weight.unsqueeze(-1),hashed.unsqueeze(0)).sum(2).transpose(1,2)#[batch,out,rank,in*k]
        # conv_weight = self.generation(conv_weight.view(batch_size, -1, self.rank)).view(batch_size, -1)
        # bias = self.bias(context)
        
        # conv_weight = self.convs(context)
        # conv_weight = conv_weight.view(batch_size, self.infilter_size * self.kernel_size, -1)

        # conv_left = self.conv_left(context).view(batch_size, -1, self.rank)
        # conv_right = self.conv_right(context).view(batch_size, self.rank, -1)
        # conv_weight = torch.bmm(conv_left, conv_right)

        # mean = conv_weight.mean(1, keepdim=True)
        # std = conv_weight.std(1, keepdim=True)
        # conv_weight = ((conv_weight - mean) / std) * self.std_conv * math.sqrt(2)
        #
        # conv_weight = conv_weight.view(batch_size, self.infilter_size * self.kernel_size, -1)

        # i = i.view(i.size(0),-1).transpose(0,1)
        # out = temp @ i
        # print(temp.size(),conv_weight.size())
        # print(temp.size(),conv_weight.size())
        out = torch.bmm(temp, conv_weight)# + bias.unsqueeze(1)
        # out = self.ln(out.transpose(1,2)).transpose(1,2)
        # out = self.ln(out)
        out = F.relu(out)
        return out


class DenseNet(nn.Module):
    def __init__(self, word_emb_dim, context_size, affine_size, filter_size, kernel_size, layer_size):
        super(DenseNet, self).__init__()
        self.padding = int((kernel_size - 1) / 2)
        self.layer_size = layer_size
        self.context_size = context_size
        self.affine = Dynamic_Conv(context_size, word_emb_dim, affine_size, 1)
        self.convs = nn.ModuleList()
        for i in range(layer_size):
            self.convs.append(Dynamic_Conv(context_size, affine_size + i * filter_size, filter_size, kernel_size))

    def forward(self, x, seq_lengths):
        output = self.affine(x,seq_lengths)
        outputs = []
        for i in range(self.layer_size):
            output_ = self.convs[i](output,seq_lengths)
            outputs.append(output_)
            output = torch.cat([output, output_], dim=-1)
        return output


# RNN Model (Many-to-One)
class DSA(nn.Module):
    def __init__(self, embed_size, context_size, affine_size, filter_size, compress_size, layer_size, kernel_size,
                 num_classes,
                 maxlen):
        super(DSA, self).__init__()
        self.embed_size = embed_size
        self.context_size = context_size
        self.num_classes = num_classes
        self.filter_size = filter_size
        self.affine_size = affine_size
        self.layer_size = layer_size
        self.kernel_size = kernel_size
        self.compress_size = compress_size
        self.maxlen = maxlen
        self.final_outchannel = affine_size + layer_size * filter_size
        self.embed = Word_embedding(embed_size, vocab_size, glove_filename, dic)
        self.densenet = DenseNet(embed_size, context_size, affine_size, filter_size, kernel_size, layer_size)

        self.compress = Dynamic_Conv(context_size,affine_size + filter_size * layer_size, filter_size, kernel_size=1)

        self.fc = nn.Sequential(nn.Linear(maxlen * filter_size, filter_size),
                                nn.ReLU(),
                                nn.Linear(filter_size, num_classes))
        self.reset_parameters()

        # self.fc = nn.Sequential(nn.Linear(max_len * channel_size // 2, num_classes))
        # self.att_vec = self.att_vec = Parameter(torch.Tensor(channel_size // 2))
        # self.att_g = Parameter(torch.Tensor([1.0]))
        # self.fc = nn.Sequential(nn.Linear(channel_size // 2, channel_size // 2), nn.ReLU(),
        #                         nn.Linear(channel_size // 2,num_classes))
        # self.final_conv = nn.Sequential(nn.Conv1d(channel_size // 2,100,kernel_size=3))
        # self.fc = nn.Linear(100,num_classes)

    def reset_parameters(self):
        # nn.init.kaiming_normal_(self.filter_conv.weight, nonlinearity='relu')
        # nn.init.xavier_normal_(self.filter_conv.weight, gain=math.sqrt(2))
        # nn.init.constant_(self.filter_conv.bias, val=0)
        # for i in self.final_conv:
        #     if isinstance(i,nn.Linear):
        #         nn.init.xavier_normal_(self.fc.weight,gain=math.sqrt(2))
        #         nn.init.constant_(self.fc.bias,val=0)

        if self.att:
            for i in self.filter_conv:
                if isinstance(i, nn.Conv1d):
                    nn.init.kaiming_normal_(i.weight)
                    # nn.init.xavier_normal_(i.weight,gain=math.sqrt(2))
                    nn.init.constant_(i.bias, val=0)
            for i in self.filter_att:
                if isinstance(i, nn.Linear):
                    nn.init.kaiming_normal_(i.weight)
                    # nn.init.xavier_normal_(i.weight,gain=math.sqrt(2))
                    nn.init.constant_(i.bias, val=0)

        for i in self.fc:
            if isinstance(i, nn.Linear):
                nn.init.kaiming_normal_(i.weight,nonlinearity='linear')
                # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
                nn.init.constant_(i.bias, val=0)
        # for i in self.compress:
        #     if isinstance(i, nn.Conv1d):
        #         nn.init.kaiming_normal_(i.weight,nonlinearity='linear')
        #         # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
        #         nn.init.constant_(i.bias, val=0)

    def forward(self, x, seq_lengths):
        batch_size = x.size(0)
        x = self.embed(x)
        # x = self.ln(x)
        length = x.size(1)
        if length < self.maxlen:
            zeros = torch.zeros(batch_size, self.maxlen, self.embed_size).to(device)  # for contextualized
            zeros[:, :length, :] = x
            x = zeros
        masks = mask_lengths(seq_lengths, self.maxlen)

        dense_out = self.densenet(x,seq_lengths)  # [[b,chnnel,len], layers

        out = self.compress(dense_out, seq_lengths)
        out *= masks[:, :, None]

        # out = self.final_conv(out) #[b,class,l]
        # out = F.max_pool1d(out,out.size(-1)).squeeze()
        # out = self.fc(out)

        out = self.fc(out.view(batch_size, -1))
        # out = out.transpose(1,2)
        # att_vec = self.att_g * (self.att_vec / torch.sqrt(torch.sum(self.att_vec ** 2)))
        # # # att_vec = self.self_att_vec
        # att_vec = att_vec.unsqueeze(0).unsqueeze(0)
        # logits = torch.sum(torch.mul(out, att_vec), -1)
        # att = softmax_with_len(logits, seq_lengths,self.max_len).unsqueeze(-1)
        # out = torch.sum(out * att, 1)
        # out *= masks[:, None, :]
        # out = self.fc(out)

        return out


# Train the Model
max_accuraries = []
for lr in init_learning_rate:
    tr.epochs = 0
    te.epochs = 0
    current_epochs = 0
    learning_rate = lr
    rnn = DSA(embedding_size, context_size, affine_size, channel_size, compress_size, layer_size, kernel_size,
              num_classes, maxlen)
    rnn.to(device)
    print(count_parameters(rnn) - count_parameters(rnn.embed))
    # Loss and Optimizer
    criterion = nn.CrossEntropyLoss().to(device)
    optimizer = torch.optim.Adam(rnn.parameters(), lr=learning_rate)
    max_accuracy = 0
    while tr.epochs < num_epochs:
        t = time.time()
        adjust_learning_rate(optimizer, learning_rate)
        cnt = 0
        rnn.train()
        while current_epochs == tr.epochs:
            cnt += 1
            pbar = tqdm(range(100))
            loss_eval = 0
            total = 0
            correct = 0
            for i in pbar:

                optimizer.zero_grad()
                for _ in range(iter_num):
                    # training_process
                    x, lengths, labels = tr.next_batch(iter_size)
                    x = torch.from_numpy(x).long().to(device)
                    labels = torch.from_numpy(labels).to(device)
                    lengths = torch.from_numpy(np.array(lengths)).to(device)
                    # Forward + Backward + Optimize
                    outputs = rnn(x, lengths)
                    _, predicted = torch.max(outputs.data, 1)
                    loss = criterion(outputs, labels).to(device)
                    loss_eval += loss.data.item()
                    loss.backward()
                    total += labels.size(0)
                    correct += (predicted == labels).sum()

                torch.nn.utils.clip_grad_norm_(rnn.parameters(), 5.0)
                optimizer.step()
                pbar.set_description("accuracy : %f loss : %f epoch : %d iter : %d" % (
                    100 * float(correct) / float(total), loss_eval / ((float(i) + 1) * iter_num), (current_epochs + 1),
                    cnt))
                if current_epochs < tr.epochs:
                    pbar.close()
                    break
        learning_rate = learning_rate * 0.1
        i = 0
        total = 0
        correct = 0
        pbar = tqdm()
        rnn.eval()
        while current_epochs == te.epochs:
            for _ in range(iter_num):
                x, lengths, labels = te.next_batch(iter_size //2)
                x = torch.from_numpy(x).long().to(device)
                lengths = torch.from_numpy(np.array(lengths)).to(device)
                labels = torch.from_numpy(labels).to(device)
                outputs = rnn(x, lengths)
                _, predicted = torch.max(outputs.data, 1)
                total += labels.size(0)
                correct += (predicted == labels).sum()
            pbar.set_description(
                "test accuracy : %f time spent %f" % (100 * float(correct) / float(total), time.time() - t))
        pbar.close()
        acc = 100 * float(correct) / float(total)
        current_epochs += 1
        # print('Test Accuracy %f%%, time spent %f ' %(100*float(correct) / float(total), time.time()-t))
        t = time.time()
# for i in range(num_layers):
#     cell = rnn.lstm.get_cell(i)
#     print(cell.weight_ar.data)
