/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.filters;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.filters.EquivalenceClassFilter;
import babel.content.eqclasses.properties.number.Number;

public class NumOccurencesFilter
implements EquivalenceClassFilter {
    protected int m_num;
    protected boolean m_keepIfMoreThen;

    public NumOccurencesFilter(int num, boolean keepIfMoreThen) {
        this.m_num = num;
        this.m_keepIfMoreThen = keepIfMoreThen;
    }

    @Override
    public boolean acceptEquivalenceClass(EquivalenceClass eqClass) {
        if (this.m_num < 0) {
            return true;
        }
        Number number = eqClass != null ? (Number)eqClass.getProperty(Number.class.getName()) : null;
        double num = number == null ? 0L : number.getNumber();
        return this.m_keepIfMoreThen && num > (double)this.m_num || !this.m_keepIfMoreThen && num <= (double)this.m_num;
    }
}

