/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.international.spanish.SpanishVerbStripper;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class ExtractorSpanishStrippedVerb
extends RareExtractor {
    private static final long serialVersionUID = -4780144226395772354L;
    private final SpanishVerbStripper verbStripper;

    public ExtractorSpanishStrippedVerb() {
        this.verbStripper = SpanishVerbStripper.getInstance();
    }

    public ExtractorSpanishStrippedVerb(String path) {
        this.verbStripper = SpanishVerbStripper.getInstance(path);
    }

    @Override
    String extract(History h, PairsHolder pH) {
        String stripped;
        String word = pH.getWord(h, 0);
        if (SpanishVerbStripper.isStrippable(word) && (stripped = this.verbStripper.stripVerb(word)) != null) {
            return stripped;
        }
        return "";
    }
}

