/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.StringUtils;
import java.util.HashSet;

public class ArrayStringFilter
implements Filter<String> {
    private final String[] words;
    private final int length;
    private final Mode mode;
    private static final long serialVersionUID = 1L;

    public ArrayStringFilter(Mode mode, String ... words) {
        if (mode == null) {
            throw new NullPointerException("Cannot handle null mode");
        }
        this.mode = mode;
        this.words = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            this.words[i] = words[i];
        }
        this.length = words.length;
    }

    @Override
    public boolean accept(String input) {
        switch (this.mode) {
            case EXACT: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equals(input)) continue;
                    return true;
                }
                return false;
            }
            case PREFIX: {
                if (input == null) {
                    return false;
                }
                for (int i = 0; i < this.length; ++i) {
                    if (!input.startsWith(this.words[i])) continue;
                    return true;
                }
                return false;
            }
            case CASE_INSENSITIVE: {
                for (int i = 0; i < this.length; ++i) {
                    if (!this.words[i].equalsIgnoreCase(input)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown mode " + (Object)((Object)this.mode));
    }

    public String toString() {
        return this.mode.toString() + ":" + StringUtils.join(this.words, ",");
    }

    public int hashCode() {
        int result = 1;
        for (String word : this.words) {
            result += word.hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArrayStringFilter)) {
            return false;
        }
        ArrayStringFilter filter = (ArrayStringFilter)other;
        if (filter.mode != this.mode || filter.length != filter.length) {
            return false;
        }
        HashSet<String> myWords = new HashSet<String>();
        for (String word : this.words) {
            myWords.add(word);
        }
        HashSet<String> otherWords = new HashSet<String>();
        for (String word : filter.words) {
            otherWords.add(word);
        }
        return ((Object)myWords).equals(otherWords);
    }

    public static enum Mode {
        EXACT,
        PREFIX,
        CASE_INSENSITIVE;

    }
}

