/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.util.Interval;
import java.util.Collection;
import java.util.List;

public abstract class MultiNodePattern<T> {
    int minNodes = 1;
    int maxNodes = -1;

    protected abstract Collection<Interval<Integer>> match(List<? extends T> var1, int var2);

    public int getMinNodes() {
        return this.minNodes;
    }

    public void setMinNodes(int minNodes) {
        this.minNodes = minNodes;
    }

    public int getMaxNodes() {
        return this.maxNodes;
    }

    public void setMaxNodes(int maxNodes) {
        this.maxNodes = maxNodes;
    }

    protected static class UnionMultiNodePattern<T>
    extends MultiNodePattern<T> {
        List<MultiNodePattern<T>> nodePatterns;

        protected UnionMultiNodePattern(List<MultiNodePattern<T>> nodePatterns) {
            this.nodePatterns = nodePatterns;
        }

        @Override
        protected Collection<Interval<Integer>> match(List<? extends T> nodes, int start) {
            Collection<Interval<Integer>> matched = null;
            for (MultiNodePattern<? extends T> multiNodePattern : this.nodePatterns) {
                Collection<Interval<Integer>> m = multiNodePattern.match(nodes, start);
                if (m == null || m.size() <= 0) continue;
                if (matched == null) {
                    matched = m;
                    continue;
                }
                for (Interval<Integer> i : m) {
                    if (matched.contains(i)) continue;
                    matched.add(i);
                }
            }
            return matched;
        }
    }

    protected static class IntersectMultiNodePattern<T>
    extends MultiNodePattern<T> {
        List<MultiNodePattern<T>> nodePatterns;

        protected IntersectMultiNodePattern(List<MultiNodePattern<T>> nodePatterns) {
            this.nodePatterns = nodePatterns;
        }

        @Override
        protected Collection<Interval<Integer>> match(List<? extends T> nodes, int start) {
            Collection<Interval<Integer>> matched = null;
            for (MultiNodePattern<? extends T> multiNodePattern : this.nodePatterns) {
                Collection<Interval<Integer>> m = multiNodePattern.match(nodes, start);
                if (m == null || m.size() == 0) {
                    return null;
                }
                if (matched == null) {
                    matched = m;
                    continue;
                }
                matched.retainAll(m);
                if (m.size() != 0) continue;
                return null;
            }
            return matched;
        }
    }
}

