theory question_65_3
imports Main

begin

typedecl entity
typedecl event

consts
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "entity ⇒ bool"
  Allow :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Flow :: "event ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  LightOn :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"

(* Explanation 1: A closed switch in a simple series circuit allows electricity to flow through the circuit. *)
axiomatization where
  explanation_1: "∀x y z e. Switch x ∧ SimpleSeriesCircuit y ∧ Closed x ⟶ (∃e. Allow e ∧ Agent e x ∧ Patient e y ∧ Electricity z ∧ Flow e ∧ Agent e z ∧ Patient e y)"

(* Explanation 2: Electricity flowing through a circuit will cause electricity to flow to a light bulb. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Electricity x ∧ Circuit y ∧ LightBulb z ∧ Flow e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Cause e2 ∧ Agent e2 e1 ∧ Patient e2 z ∧ Flow e2 ∧ Agent e2 x ∧ Patient e2 z)"

(* Explanation 3: A light bulb turning on indicates that the light comes on. *)
axiomatization where
  explanation_3: "∀x y. LightBulb x ∧ TurnOn y ∧ Agent y x ⟶ LightOn x"

theorem hypothesis:
  (* Premise: When the switch in a simple series circuit is closed, electricity flows to the light bulb. *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed x ∧  Allow e ∧ Agent e x ∧ Patient e y ∧ Electricity z ∧ Flow e ∧ Agent e z ∧ Patient e y "
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e. Electricity x ∧ LightBulb y ∧ Flow e ∧ Agent e x ∧ Patient e y ∧ LightOn y"
proof -
  from asm have "Electricity z" by simp
  then have "∃e. Flow e ∧ Agent e z ∧ Patient e y" using explanation_1 by blast
  then obtain e1 where e1: "Flow e1 ∧ Agent e1 z ∧ Patient e1 y" by auto
  then have "Electricity x ∧ Flow e1 ∧ Agent e1 x ∧ Patient e1 y" using asm by simp
  then have "Cause e2 ∧ Agent e2 e1 ∧ Patient e2 z ∧ Flow e2 ∧ Agent e2 x ∧ Patient e2 z" using explanation_2 by blast
  then have "LightBulb z" using asm by auto
  then have "LightOn z" using explanation_3 by blast
  then show ?thesis using e1 asm by blast
qed

end
