theory question_95_6
imports Main

begin

typedecl entity
typedecl event

consts
  TumultuousClouds :: "entity ⇒ bool"
  BlueSky :: "entity ⇒ bool"
  Cloud :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Above :: "entity ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Deck :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Sky :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  AboutTo :: "entity ⇒ (entity ⇒ bool) ⇒ bool"
  OverTakenBy :: "event ⇒ bool"

(* Explanation: The sky being blue and having clouds implies that the clouds are in the sky. *)
axiomatization where
  explanation: "∀s l. Sky s ∧ Blue s ∧ Cloud l ⟶ In l s"

theorem hypothesis:
  (* Premise: A man and a woman are on a deck under a sky that is about to be overtaken by tumultuous clouds. *)
  assumes asm: "Man m ∧ Woman w ∧ Deck d ∧ On m d ∧ On w d ∧ Sky s ∧ BlueSky s ∧ AboutTo s  OverTakenBy o "
  (* Hypothesis: There is a sky that is blue and has clouds in it. *)
  shows "∃s. Sky s ∧ Blue s ∧ ∀l. Cloud l ∧ In l s"
proof -
  from asm have "Sky s ∧ BlueSky s" by auto
  then have "Sky s ∧ Blue s" using BlueSky_def by simp
  then show ?thesis by (rule impI; rule exI; rule conjI; use asm in aper)
qed

end
