theory question_7_1
imports Main
begin

typedecl entity
typedecl event

consts
  Girl :: "entity ⇒ bool"
  YellowRope :: "entity ⇒ bool"
  JumpingOver :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  JumpingRope :: "entity ⇒ bool"

(* Explanation 1: If a girl exists and she is jumping over a yellow rope, then she is jumping rope. *)
axiomatization where
  explanation_1: "∀x e. Girl x ∧ YellowRope e ∧ JumpingOver e x ⟶ JumpingRope x"

(* Explanation 2: The girl is jumping over a yellow rope. *)
axiomatization where
  explanation_2: "∃x e. Girl x ∧ YellowRope e ∧ JumpingOver e x ∧ Agent e x"

theorem hypothesis:
  (* Premise: A little girl is jumping over a yellow rope. *)
  assumes asm: "LittleGirl x ∧ YellowRope e ∧ JumpingOver e x ∧ Agent e x"
  (* Hypothesis: A girl jumps rope. *)
  shows "∃x e. Girl x ∧ JumpingRope x"
proof -
  from asm have "Girl x" by blast
  from this have "JumpingRope x" using explanation_1 by blast
  show ?thesis using `Girl x` `JumpingRope x` by blast
qed

end
