# -*- coding: utf-8 -*-

import argparse
import os
import sys

from . import magic_pack as packer
from .magic_load import magic_load_internal


def main():
    parser = argparse.ArgumentParser(__name__)
    parser.add_argument('mode', default='main', type=str, choices=['main', 'shell'],
                        help='main: run entry point of this model;'
                             'shell: start REPL in this environment.')

    options, cmd_args = parser.parse_known_args()

    sys.argv = [sys.argv[0]] + cmd_args  # directly modify sys.argv

    packed_file = os.path.abspath(options.packed_file)
    packed_dir = os.path.dirname(packed_file)
    data_bytes = open(packed_file, 'rb')

    return magic_load_internal(data_bytes,
                               working_dir=packed_dir,
                               packer=packer,
                               use_shell=(options.mode == 'shell'))


if __name__ == '__main__':
    main()
