# -*- coding: utf-8 -*-


import errno
import functools
import os
import signal


class TimeoutError(Exception):
    pass


def timeout(seconds, error_message=os.strerror(errno.ETIME), handler=None):
    if handler is None:
        def handler(signum, frame):
            raise TimeoutError(error_message)

    def decorator(func):
        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            signal.signal(signal.SIGALRM, handler)
            signal.alarm(seconds)
            try:
                result = func(*args, **kwargs)
            finally:
                signal.alarm(0)
            return result

        return wrapper

    return decorator
