#ifndef _DEPGRAPH_H
#define _DEPGRAPH_H

#include <tuple>
#include <vector>
#include <set>
#include <string>
#include <iostream>
#include <sstream>
#include <unordered_set>
#include "include/ngram.h"
#include "common/token/token.h"
#include "common/token/deplabel.h"
#include "common/token/supertag.h"
#include "macros_base.h"

namespace graph_merging {
class graph_decomposer_tg;
class graph_decomposer_gg;
}
namespace graph_merging_1L {
	class graph_DDdecoder_tree_graph;
	class graph_DDdecoder_graph_graph;
}
namespace graph_merging_2gc {
	class graph_DDdecoder_tree_graph;
	class graph_DDdecoder_graph_graph;
}
namespace graphcjj1L {
class DepParser;
}
namespace graphcjj2gc_prune {
class DepParser;
}
namespace graphcjj2gc_prune_notree {
class DepParser;
}

typedef std::tuple<int, int, ttoken> GraphEdge;
#define EDGE_X(X)			(std::get<0>(X))
#define EDGE_Y(X)			(std::get<1>(X))
#define EDGE_LABEL(X)		(std::get<2>(X))

class DependencyGraph
{
private:
	std::vector<POSTaggedWord> m_lSentence;
	std::vector<GraphEdge> m_lGraph;
	DependencyTree m_lTree;
	std::vector<BiGram<int> > m_lCrossEdge;
public:

	void clear()
	{
		m_lSentence.clear();
		m_lGraph.clear();
		m_lTree.clear();
	}
	void merge(DependencyGraph graphA,DependencyGraph graphB){
		clear();
		int sentLen = graphA.m_lSentence.size();
		m_lTree.assign(graphA.m_lTree.begin(),graphA.m_lTree.end());
		std::vector<std::vector<int>> gr_mat(sentLen+1, std::vector<int>(sentLen+1, 0));
		for (auto posword : graphA.m_lSentence)
			m_lSentence.push_back(posword);
		for (auto &edge : graphA.m_lGraph)
			if (gr_mat[EDGE_X(edge)][EDGE_Y(edge)] == 0){
				gr_mat[EDGE_X(edge)][EDGE_Y(edge)] = 1;
				m_lGraph.push_back(edge);
			}
		for (auto &edge : graphB.m_lGraph){
			if (gr_mat[EDGE_X(edge)][EDGE_Y(edge)] == 0){
				gr_mat[EDGE_X(edge)][EDGE_Y(edge)] = 1;
				m_lGraph.push_back(edge);
			}
		}
	}
	void merge(DependencyTree tree_dd,DependencyGraph graph_dd){
		clear();
		m_lTree.assign(graph_dd.m_lTree.begin(),graph_dd.m_lTree.end());
		for (auto posword : graph_dd.m_lSentence)
			m_lSentence.push_back(posword);
		for (auto edge : graph_dd.m_lGraph){
			std::string tree_label = EDGE_LABEL(edge);
			int tree_at = tree_label.length() - 2;
			tree_label = tree_label.substr(0, tree_at);
			int from = EDGE_X(edge);
			int to = EDGE_Y(edge);
			if (tree_label.length() > 2 && tree_label.substr(tree_at - 2, 2) == "~R"){
				tree_label = tree_label.substr(0, tree_at - 2);
				std::swap(from,to);
			}
			m_lGraph.push_back(GraphEdge(from, to, tree_label));
		}
		for (int i = 0; i < tree_dd.size(); ++i) {
			std::string tree_label = TREENODE_LABEL(tree_dd[i]);
			int tree_at = tree_label.length() - 2;
			int tree_tag = std::stoi(tree_label.substr(tree_at + 1, 1));
			tree_label = tree_label.substr(0, tree_at);
			if (tree_label == "None")
				continue;
			int from = TREENODE_HEAD(tree_dd[i]) + 1;
			int to = i + 1;
			if (tree_label.length() > 2 && tree_label.substr(tree_at - 2, 2) == "~R"){
				tree_label = tree_label.substr(0, tree_at - 2);
				std::swap(from,to);
			}
			m_lGraph.push_back(GraphEdge(from, to, tree_label));
		}
	}

	friend std::istream & operator>>(std::istream & is, DependencyGraph& depgraph) {
		ttoken token,line;
		std::vector<ttoken> vector_token;
		std::vector<int> vector_head;
		vector_token.clear();
		vector_head.clear();
		depgraph.clear();
		int fn = 0,n = 0;
		int debug = 0;
		int root = 0;
		depgraph.m_lTree.push_back(DependencyTreeNode(POSTaggedWord(ROOT_WORD, ROOT_POSTAG), - 1, ROOT_DEPLABEL));
		while (true) {
			std::getline(is, line);
			if (line.empty()) {
				break;
			}
			//std::cout << line << std::endl;
			n++;
			DependencyTaggedTreeNode node;
			std::istringstream iss(line);
			int x,head;
			ttoken word, tag , label,fathers;
			iss >> x >> word >> token >> tag >> token >> token >> token >> token >> head >> label >> token;
			if (head == -1)
				root = -1;
			std::getline(iss, fathers);
			if (debug)
			{
				std::cout << x << ' ' << word << ' ' << tag << ' ' << head << ' ' << label << ' ' <<token<< ' ' << fathers << std::endl;
			}
			depgraph.m_lSentence.push_back(POSTaggedWord(word, tag));
			depgraph.m_lTree.push_back(DependencyTreeNode(POSTaggedWord(word, tag),head,label));
			vector_token.push_back(fathers);
			if (token != "_") { ++fn; vector_head.push_back(x); }
		}
		if (root == -1)
			for (int i = 1 ; i <= n ; i++)
				depgraph.m_lTree[i] = DependencyTreeNode(std::get<0>(depgraph.m_lTree[i])
														,std::get<1>(depgraph.m_lTree[i])+1
														,std::get<2>(depgraph.m_lTree[i]));
		for (int j = 0; j < n; j++)
		{
			std::istringstream iss(vector_token[j]);
			for (int i = 0; i < fn; i++)
			{
				iss >> token;
				if (token == "_") continue;
				else depgraph.m_lGraph.push_back(GraphEdge(vector_head[i], j + 1, token));
			}			
		}
		if (debug)
		{
			for (const auto arc : vector_head)
				std::cout << arc <<' ';
			std::cout<<std::endl;
		}
		
		return is;
	}
	friend std::ostream & operator<<(std::ostream &os, DependencyGraph& depgraph) {

		int sentLen = depgraph.m_lSentence.size();

		std::vector<std::vector<ttoken>> gr_mat(sentLen, std::vector<ttoken>(sentLen, "_"));
		std::vector<bool> has_child(sentLen, false);
		for (auto edge : depgraph.m_lGraph) {

			int from = EDGE_X(edge);
			int to = EDGE_Y(edge);
			gr_mat[from - 1][to - 1] = EDGE_LABEL(edge);
			has_child[from - 1] = true;
		}
		char charin = ' ';
		for (int i = 0; i < sentLen; ++i) {
			std::string word = SENT_WORD(depgraph.m_lSentence[i]);
			std::string pos = SENT_POSTAG(depgraph.m_lSentence[i]);
			std::string head = "_";
			std::string label = "_";
			if (!depgraph.m_lTree.empty()) {
				std::stringstream ss;
				ss << (TREENODE_HEAD(depgraph.m_lTree[i + 1]));
				head = ss.str();
				label = TREENODE_LABEL(depgraph.m_lTree[i + 1]);
			}
			os << (i + 1) << charin << word << charin << word << charin << pos << charin << pos
					<< " _ _ _ " << head << charin << label << charin;
			if (has_child[i]) {
				os << word;
			} else {
				os << "_";
			}
			for (int j = 0; j < sentLen; ++j) {
				if (has_child[j]) {
					os << " " << gr_mat[j][i];
				}
			}
			os << std::endl;
		}
		os << std::endl;
		return os;
	}
	void print() const
	{
		for (const auto arc : m_lGraph)
		{
			std::cout << EDGE_X(arc) << ' ' << EDGE_Y(arc) << ' ' << EDGE_LABEL(arc) << std::endl;
		}
	}

	std::vector<POSTaggedWord> getSentence() const
	{
		return m_lSentence;
	}
	std::vector<GraphEdge> getGraph() const
	{
		return m_lGraph;
	}

	DependencyTree getTree() const
	{
		return m_lTree;
	}

	bool IsProjective()
	{
		m_lCrossEdge.clear();
		for (int i = 0; i < m_lGraph.size(); i++)
			for (int j = i + 1; j < m_lGraph.size(); j++)
			{
				auto arc1 = m_lGraph[i], arc2 = m_lGraph[j];
				if (cross(arc1, arc2)) m_lCrossEdge.push_back(BiGram<int>(i, j));
			}
		if (m_lCrossEdge.size() == 0)
			return true;
		else return false;
	}

	bool OneCross()
	{
		for (const auto arc1 : m_lGraph)
		{
			int num = 0;
			for (const auto arc2 : m_lGraph)
				if (cross(arc1, arc2)) num++;
			if (num > 1) return false;
		}
		return true;
	}

	bool HaveTwoDirection()
	{
		for (const auto arc1 : m_lGraph)
			for (const auto arc2 : m_lGraph)
			{
				if ( EDGE_X(arc1) == EDGE_Y(arc2) && EDGE_X(arc2) == EDGE_Y(arc1) )
					return true;
			}
		return false;
	}

	bool HaveSingleRing()
	{
		for (const auto arc1 : m_lGraph)			
			{
				if (EDGE_X(arc1) == EDGE_Y(arc1))
					return true;
			}
		return false;
	}

	bool cross(GraphEdge arc1, GraphEdge arc2)
	{
		return ( (EDGE_X(arc1) - EDGE_X(arc2)) * (EDGE_X(arc1) - EDGE_Y(arc2))
			* (EDGE_Y(arc1) - EDGE_X(arc2)) * (EDGE_Y(arc1) - EDGE_Y(arc2)) < 0) ||
			( (EDGE_X(arc1) == EDGE_Y(arc2)) && (EDGE_X(arc2) == EDGE_Y(arc1) ) );
		
	}

	bool HaveTailPoint()
	{
		int n = m_lSentence.size();
		for (const auto arc1 : m_lGraph)
		{
			if (EDGE_X(arc1) == n || EDGE_Y(arc1) == n)
				return true;
		}
		return false;
	}

	bool OneEdgeCut_Plannar(int op)
	{
		for (int ii = 0; ii < m_lGraph.size(); ii++)
		{
			int flag = 1;
			for (auto arc : m_lCrossEdge)
			{
				if (arc.first() != ii && arc.second() != ii)
					flag = 0;
			}
			if (flag)
			{
				if (op == 1)
				{
					auto arccut = m_lGraph[ii];
					std::vector<GraphEdge>::iterator Iter;
					for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
						if ((*Iter) == arccut)
						{m_lGraph.erase(Iter); break;}
				}
				return true;
			}
		}
		return false;
	}

	bool TwoEdgeCut_Plannar(int op)
	{
		for (int ii = 0; ii < m_lGraph.size(); ii++)
			for (int jj = ii + 1; jj < m_lGraph.size(); jj++)
		{
			int flag = 1;
			for (auto arc : m_lCrossEdge)
			{
				if (arc.first() != ii && arc.second() != ii && 
					arc.first() != jj && arc.second() != jj)
					flag = 0;
			}
			if (flag)
			{
				if (op == 1)
				{
					auto arccut1 = m_lGraph[ii], arccut2 = m_lGraph[jj];
					std::vector<GraphEdge>::iterator Iter;
					for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
						if ((*Iter) == arccut1)
						{
							m_lGraph.erase(Iter); break;
						}
					for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
						if ((*Iter) == arccut2)
						{
							m_lGraph.erase(Iter); break;
						}
				}
				return true;
			}
		}
		return false;
	}

	bool ThreeEdgeCut_Plannar(int op)
	{
		for (int ii = 0; ii < m_lGraph.size(); ii++)
			for (int jj = ii + 1; jj < m_lGraph.size(); jj++)
				for (int kk = jj + 1; kk < m_lGraph.size(); kk++)
				{
					int flag = 1;
					for (auto arc : m_lCrossEdge)
					{
						if (arc.first() != ii && arc.second() != ii &&
							arc.first() != jj && arc.second() != jj &&
							arc.first() != kk && arc.second() != kk)
							flag = 0;
					}
					if (flag)
					{
						if (op == 1)
						{
							auto arccut1 = m_lGraph[ii], arccut2 = m_lGraph[jj],arccut3 = m_lGraph[kk];
							std::vector<GraphEdge>::iterator Iter;
							for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
								if ((*Iter) == arccut1)
								{
									m_lGraph.erase(Iter); break;
								}
							for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
								if ((*Iter) == arccut2)
								{
									m_lGraph.erase(Iter); break;
								}
							for (Iter = m_lGraph.begin(); Iter != m_lGraph.end(); Iter++)
								if ((*Iter) == arccut3)
								{
									m_lGraph.erase(Iter); break;
								}
						}
						return true;
					}
				}
		return false;
	}

	int SinglePoint(int op)
	{
		std::unordered_set<int> single;
		int n = m_lSentence.size();
		single.clear();
		for (int i = 1; i <= n; i++)
			single.insert(n);
		for (auto arc : m_lGraph)
		{
			single.erase(EDGE_X(arc));
			single.erase(EDGE_Y(arc));
		}
		if (op == 0)
			return single.size();
		else if (op == 1)
		{
			int sum = 0;
			for (auto arc : single)
				if (TREENODE_LABEL(m_lTree[arc - 1]) == "punct") sum++;
			return sum;
		}
	}

	int SumPoint()
	{
		return m_lSentence.size();
	}
	/*bool ThreeEdgeCut_Plannar()
	{
		for (int ii = 0; ii < m_lGraph.size(); ii++)
			for (int jj = ii + 1; jj < m_lGraph.size(); jj++)
				for (int kk = jj + 1; kk < m_lGraph.size(); kk++)
		{
			int flag = 1;
			for (int i = 0; i < m_lGraph.size(); i++)
			{
				auto arc1 = m_lGraph[i];
				if (i != ii && i != jj && i != kk)
				for (int j = i + 1; j < m_lGraph.size(); j++)
				{
					auto  arc2 = m_lGraph[j];
					if (j != ii && j != jj && j != kk &&
						(cross(arc1, arc2)))
						flag = 0;
				}
			}				
			if (flag) return true;
		}
		return false;
	}*/

//	friend std::ostream & operator<<(std::ostream & os, DependencyGraph& depgraph)
//	{
//		for (const auto arc : depgraph.m_lGraph)
//		{
//			os << EDGE_X(arc) << ' ' << EDGE_Y(arc) << ' ' << EDGE_LABEL(arc) << std::endl;
//		}
//		return os;
//	}

	friend class graph_merging::graph_decomposer_tg;
	friend class graph_merging::graph_decomposer_gg;
	friend class graphcjj1L::DepParser;
	friend class graphcjj2gc_prune::DepParser;
	friend class graphcjj2gc_prune_notree::DepParser;
	friend class graph_merging_1L::graph_DDdecoder_tree_graph;
	friend class graph_merging_2gc::graph_DDdecoder_tree_graph;
	friend class graph_merging_1L::graph_DDdecoder_graph_graph;
	friend class graph_merging_2gc::graph_DDdecoder_graph_graph;

};





#endif
