/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.Exceptions;
import fig.basic.IOUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.record.ReceiverInterface;
import fig.record.RecordNode;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class RecordNodeUtils {
    public static void sendRecordNodetoReceiver(RecordNode record, ReceiverInterface receiver) throws RemoteException {
        RecordNodeUtils.sendRecordNodetoReceiverHelper(record, receiver, 0, false);
    }

    public static void sendRecordNodetoReceiverHelper(RecordNode record, ReceiverInterface receiver, int indent, boolean displayRoot) throws RemoteException {
        if (displayRoot) {
            receiver.printOut(StrUtils.repeat("  ", indent));
            receiver.printOut(String.valueOf(record.getDescription(RecordNode.DescriptionType.human)) + "\n");
        }
        for (RecordNode child : record.getChildren()) {
            RecordNodeUtils.sendRecordNodetoReceiverHelper(child, receiver, indent + (displayRoot ? 1 : 0), true);
        }
    }

    public static void writeRecordNode(RecordNode record, String path, boolean append) {
        PrintWriter out = append ? IOUtils.openOutAppendHard(path) : IOUtils.openOutHard(path);
        RecordNodeUtils.writeRecordNodeHelper(record, out, 0, false);
        out.close();
    }

    public static void writeRecordNodeHelper(RecordNode record, PrintWriter out, int indent, boolean displayRoot) {
        if (displayRoot) {
            out.print(StrUtils.repeat("\t", indent));
            out.print(String.valueOf(record.getDescription(RecordNode.DescriptionType.machine)) + "\n");
        }
        for (RecordNode child : record.getChildren()) {
            RecordNodeUtils.writeRecordNodeHelper(child, out, indent + (displayRoot ? 1 : 0), true);
        }
    }

    public static RecordNode appendKeyValue(RecordNode node, String key, String value) {
        return node.shallowCopy(node.getKey(), String.valueOf(node.getValue()) + "\t" + RecordNodeUtils.getDescription(key, value, RecordNode.DescriptionType.human));
    }

    public static RecordNode prependKeyValue(RecordNode node, String key, String value) {
        return node.shallowCopy(key, String.valueOf(value) + "\t" + RecordNodeUtils.getDescription(node.getKey(), node.getValue(), RecordNode.DescriptionType.human));
    }

    public static double getDoubleValue(RecordNode node) {
        return Utils.parseDoubleEasy(RecordNodeUtils.getPrimaryValue(node));
    }

    public static String getPrimaryValue(RecordNode node) {
        String s = node.getValue();
        if (s == null) {
            return null;
        }
        int i = s.indexOf(9);
        if (i != -1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public static String getDescription(String key, String value, RecordNode.DescriptionType type) {
        if (type == RecordNode.DescriptionType.machine) {
            return String.valueOf(key) + (value == null ? "" : "\t" + value);
        }
        if (type == RecordNode.DescriptionType.human) {
            if (key == null) {
                return value == null ? "" : value;
            }
            return String.valueOf(key) + (value == null ? "" : "=" + value);
        }
        throw Exceptions.unknownCase;
    }
}

