/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.MapFactory;
import java.util.Map;
import java.util.Set;

public class Interner<T> {
    Map<T, T> canonicalMap;
    CanonicalFactory<T> cf;

    public Set<T> getCanonicalElements() {
        return this.canonicalMap.keySet();
    }

    public boolean isCanonical(T x) {
        return this.canonicalMap.containsKey(x);
    }

    public T intern(T object) {
        T canonical = this.canonicalMap.get(object);
        if (canonical == null) {
            canonical = this.cf.build(object);
            this.canonicalMap.put(canonical, canonical);
        }
        return canonical;
    }

    public T getCanonical(T object) {
        T canonical = this.canonicalMap.get(object);
        return canonical == null ? object : canonical;
    }

    public int size() {
        return this.canonicalMap.size();
    }

    public Interner() {
        this(new MapFactory.HashMapFactory(), new IdentityCanonicalFactory());
    }

    public Interner(MapFactory<T, T> mf) {
        this(mf, new IdentityCanonicalFactory());
    }

    public Interner(CanonicalFactory<T> f) {
        this(new MapFactory.HashMapFactory(), f);
    }

    public Interner(MapFactory<T, T> mf, CanonicalFactory<T> cf) {
        this.canonicalMap = mf.buildMap();
        this.cf = cf;
    }

    public static interface CanonicalFactory<T> {
        public T build(T var1);
    }

    static class IdentityCanonicalFactory<T>
    implements CanonicalFactory<T> {
        IdentityCanonicalFactory() {
        }

        @Override
        public T build(T object) {
            return object;
        }
    }
}

