///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <fstream>
#include <sstream>
#include <getopt.h>

#include "nl-randvar.h"
#include "nl-dtree.h"
#include "nl-iomacros.h"
#include "nl-refrv.h"
//#include "nl-modelfile.h"

//char psX[]="";
//char psUscUscUsc[]="___";

//#define NOISY 1

#define THRESHOLD 0.0

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

#include "TextObsVars.h"
#include "PCFGLangModel-vecmd.h"
#include "TextObsModel-svs.h"

////////////////////////////////////////////////////////////////////////////////
//
//  helper classes, functions
//
////////////////////////////////////////////////////////////////////////////////

bool NOISY = false;

class ChartCell {
private:
  static const ChartCell xDummy;
  bool             bRooted;
  G                g;
  int              k;
  const ChartCell* px1;
  const ChartCell* px2;
  LogProb          pr; // max
public:
  ChartCell ( )                                                                      : bRooted(false), g(),   k(0),  px1(NULL), px2(NULL), pr()    { }
  ChartCell ( G& gA, LogProb prA )                                                   : bRooted(false), g(gA), k(0),  px1(NULL), px2(NULL), pr(prA) { }
  ChartCell ( G& gA, const ChartCell& x1, LogProb prA )                              : bRooted(false), g(gA), k(0),  px1(&x1),  px2(NULL), pr(prA) { }
  ChartCell ( G& gA, int kA, const ChartCell& x1, const ChartCell& x2, LogProb prA ) : bRooted(false), g(gA), k(kA), px1(&x1),  px2(&x2),  pr(prA) { }
  ChartCell ( const G& gA, int kA, const ChartCell& x1, const ChartCell& x2, LogProb prA ) : bRooted(false), g(gA), k(kA), px1(&x1),  px2(&x2),  pr(prA) { }
  void setRooted ( )       { bRooted=true; }
  bool getRooted ( ) const { return bRooted; }
  bool operator!= ( const ChartCell& x ) const { return (g!=x.g || k!=x.k || px1!=x.px1 || px2!=x.px2 || pr!=x.pr); }
  const G&         getG    ( ) const { return g;  }
  int              getK    ( ) const { return k;  }
  const UDLC&      getUDLC ( ) const { return g.first; }
  const Evec&      getE    ( ) const { return g.second; }
  const ChartCell& getX1   ( ) const { return (px1!=NULL) ? *px1 : xDummy; }
  const ChartCell& getX2   ( ) const { return (px2!=NULL) ? *px2 : xDummy; }
  LogProb          maxProb ( ) const { return pr; }
  void prune      ( ) { /*???*/ }
  void writeBest  ( FILE* pf, List<W>& lw ) const { 
    //fprintf(pf," (%s:%s{%s}",g.first.second.first.getString().c_str(),g.first.second.second.getString().c_str(),
    //g.second.argmax().first.getString().c_str()); // SUSPECT
    fprintf(pf," (%s:%s",g.first.second.first.getString().c_str(),g.first.second.second.getString().c_str());
    if(px1)px1->writeBest(pf,lw);
    if(px2)px2->writeBest(pf,lw);
    if(!px1 && !px2){fprintf(pf," ");fprintf(pf,"%s",lw.getFirst()->getString().c_str());lw.pop();}
    fprintf(pf,")"); }
  void writePath  ( FILE* pf, List<W>& lw ) const { 
    //fprintf(pf," (%s:%s{%s}",g.first.second.first.getString().c_str(),g.first.second.second.getString().c_str(),
    //g.second.argmax().first.getString().c_str()); // SUSPECT
    fprintf(pf," (%s:%s[%d]",g.first.second.first.getString().c_str(),g.first.second.second.getString().c_str(),pr.toInt());
    if(px1)px1->writePath(pf,lw);
    if(px2)px2->writePath(pf,lw);
    if(!px1 && !px2){fprintf(pf," ");fprintf(pf,"%s",lw.getFirst()->getString().c_str());lw.pop();}
    fprintf(pf,")"); }
};
const ChartCell ChartCell::xDummy;

////////////////////////////////////////////////////////////////////////////////

typedef SimpleHash<UDLC,ChartCell> RefCell;
//std::map<G2Cell,G2Cell> domCell;
//typedef RefRV<G2Cell,domCell> RefCell;
//typedef SafePtr<G2Cell> RefCell;
//typedef pair<G,ChartCell> GCell;
//std::map<GCell,GCell> domCell;
//typedef RefRV<GCell,domCell> RefCell;


////////////////////////////////////////////////////////////////////////////////

// NOTE: unary rules deprecated
void tryUnary ( SafeArray2D<Id<int>,Id<int>,RefCell>& axChart, int i, int j, const ChartCell& xG, const GuModel& modGgivG ) {
  /*
  G gP;
  //  for ( bool bgp=gP.setFirst(); bgp; bgp=gP.setNext() ) {
  for ( GuModel::const_iterator iter = modGgivG.begin(); iter!=modGgivG.end(); iter++ ) {
    G          gP = iter->first.getX1();
    G          gg = xG.getG();
    ChartCell& xP = axChart.set(i,j).set(gP.first);
    LogProb    pr = modGgivG.getProb(gg,gP) * xG.maxProb(); //diag( modGgivG.getVec(gg,gP) ) * xG.getE(); // does not work
    if ( pr>xP.maxProb() ) {
      xP = ChartCell(gP,xG,pr);
      if ( NOISY )
        cout << "unary match! " << i << " " << j << " " << gP.first << " -> " << gg.first << " -> " << pr.toInt() << endl;
      tryUnary ( axChart, i, j, xP, modGgivG );
    }
  }
  */
}


////////////////////////////////////////////////////////////////////////////////
//
//  Main Function (pipe data input)
//
////////////////////////////////////////////////////////////////////////////////

static struct option long_options[] = {
  {"forest", optional_argument, 0, 'f'},
  {"help", no_argument, 0, 'h'},
  {"verbose", no_argument, 0, 'v'},
  {0, 0, 0, 0} };

void printUsage(char* progname) {
  fprintf(stderr,"Usage: cat <RAW_FILE> | %s [OPTIONS]... [MODEL_FILE1] [MODEL_FILE2] ...\n",progname);
  fprintf(stderr,"Runs the speech recognition system on RAW_FILE using the models in MODEL_FILE1, 2, etc.\n");
  fprintf(stderr," System variable Settings:\n");
  fprintf(stderr,"  -f, --forest=TRUE\n");
  fprintf(stderr,"  -h, --help\t\tPrint this message\n");
  fprintf(stderr,"  -v, --verbose=TRUE\n");
}

int main (int nArgs, char* argv[]) {

  //modGgivG.NOISY_READ = true;

  bool FOREST = false;

  //GGModel modGGgivG;
  MModel  modM;
  LModel  modL;
  GuModel modGgivG;
  GrModel modGr;
  GModel  modG;
  LCModel modLC;
  IModel  modI;
  OModel  mO;

  // Parse command-line options
  char* progname = strdup(argv[0]);
  int option_index = 0;
  char opt;
  while( (opt = getopt_long(nArgs, argv, "fhv", long_options, &option_index)) != -1 ) {
    switch(opt) {
    case 'f': FOREST=true; break;
    case 'h': printUsage(progname); exit(0);
    case 'v': NOISY=true; break;
    default: break;
    }
  }

  for ( int a=optind; a<nArgs; a++ ) {
    FILE* pf = fopen(argv[a],"r"); assert(pf);                                // READ MODEL FILE
    cerr << "Loading model \'" << argv[a] << "\'...\n";
    int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      String sBuff2(sBuff); StringInput si(sBuff2.c_array());
      //sBuff.split(aps," :=");                                                  //   Split into fields
      //cerr<<si.c_str()<<endl;
      if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
              //si>>mH>>"\0"!=NULL ||
	      si>>"M_SIZE ">>M_SIZE>>"\0"!=NULL ||
              si>>mO>>"\0"!=NULL ||
	      si>>"LC ">>modLC>>"\0"!=NULL || 
	      si>>"Gr ">>modGr>>"\0"!=NULL || 
	      si>>"G ">>modG>>"\0"!=NULL || 
	      //si>>"Gu ">>modGgivG>>"\0"!=NULL || 
	      //si>>"GG ">>modGGgivG>>"\0"!=NULL ) )
	      si>>"HW ">>modI>>"\0"!=NULL || 
	      si>>"M ">>modM>>"\0"!=NULL || 
	      si>>"L ">>modL>>"\0"!=NULL ) )
	//si>>"Pc ">>modPgivCvar>>"\0"!=NULL ||
	//si>>"Pw ">>modPgivWs>>"\0"!=NULL ||
	//si>>"PwDT ">>modPgivWdt>>"\0"!=NULL ||
	//si>>"P ">>modP>>"\0"!=NULL ) )
	////mH.readFields(aps) || mO.readFields(aps)*/ ) )
	//	cerr<<"\nERROR: "<<aps.size()<<"-arg "<<((aps.size()>0)?aps[0]:"??")<<" in line "<<line<<"\n\n";
	cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    cerr << "Model \'" << argv[a] << "\' loaded.\n";
  }
  //   for ( int i=optind; i<nArgs; i++ ) {
  //     cerr << "Loading model \'" << argv[i] << "\'\n";
  //     FILE* pf = fopen(argv[i],"r"); 
  //     assert(pf);
  //     processModelFilePtr ( pf, readFields );
  //     cerr << "Model \'" << argv[i] << "\' loaded.\n";
  //   }

  ifstream fin;
  List<W>  lw;
  string   sLine;
  int ctr=0;
  IndexedVector N_1 ( M_SIZE.getInt(), 1, Prob(1.0) );

  //  if (nArgs>2) fin.open(argv[2]);

  // Read in each line...
  //  while ( (nArgs>2) ? getline(fin,sLine) : getline(cin,sLine) ) {
  while ( getline(cin,sLine) ) {
    ctr++;
    cerr << ctr ;

    // Read in each word...
    stringstream ss(stringstream::in|stringstream::out);
    lw=List<W>();
    ss<<sLine;
    for (string s; ss>>s; ) {
      cerr << " " << s;
      lw.add() = W(s.c_str()); //.read(s);
    }

    cerr << endl;

    // Allocate chart...
    SafeArray2D<Id<int>,Id<int>,RefCell> axChart;
    int n = lw.getCard();
    axChart.init ( n+1, n+2 );

    // Initialize chart with terminals (POSs)...
    int i=0;
    Listed(W)* pw;
    foreach(pw,lw) {

      //OModel::RandVarType w; w = *static_cast<W*>(pw);
      OModel::RandVarType w; w.set(*pw,mO);
      if ( NOISY )
        cerr << "word " << pw->getString() << endl;
      //for ( CPT2DModel<P,C,LogProb>::const_iterator iter = modPgivCvar.begin(); iter!=modPgivCvar.end(); iter++ ) {
      //  C c = iter->first.getX1();

      //G g;
      //for ( bool bG=g.setFirst(); bG; bG=g.setNext() ) {
      U u;
      for ( bool bu=u.setFirst(); bu; bu=u.setNext() ) {
	D d;
	for ( bool bd=d.setFirst(); bd; bd=d.setNext() ) {
	  UD ud(u,d);
	  LCModel::IterVal lc;
	  for ( bool blc=modLC.setFirst(lc); blc; blc=modLC.setNext(lc) ) {
        if (lc.second.getTerm()==B_0) { continue; }  // non-terms never generate words

	    UDLC udlc (ud, LC(lc));
	    I iw (pw->getString().c_str());
	    //E ew;
	    G g;
	    Evec e;
        LogProb lpr;

	    // Set unknown words to "unk" vector  
	    if ( !modI.contains(iw) ) {
	      iw = I_UNK;
          lpr = w.getProb(lc.second);
          //cerr<<" set i to unk for "<<I_UNK<<" "<<lc<<" = "<<w.getProb(lc.second)<<endl;
        } else {
          lpr = w.getProb(lc.second,iw);
        }
	    //ew = E(iw.getString().c_str());
	    // Look for the probability
	    if ( lpr!=LogProb() ) {
	      e = Evec( iw, lpr.toProb() );
	    }
	    if (e.infnorm()==Prob()) { //cerr<<" WARNING: in pos search, category "<<lc<<" never matched a referent. iw="<<iw<<" p="<< w.getProb(lc.second,iw).toProb()<<endl; 
	      continue; 
	    } //else { cerr<<" no warning for "<<lc<<" iw="<<iw<<" p="<<w.getProb(lc.second,iw).toProb()<<endl; }
	    g = G( udlc, e );

	    ChartCell* px = &axChart.set(i,i+1).set(udlc);
	    *px = ChartCell ( g, g.second.infnorm() );
	    //tryUnary ( axChart, i, i+1, *px, modGgivG );
	    if ( NOISY )
	      cerr << "pos match! " << i << " " << i+1 << " " << g.first << " -> " << pw->getString()
		   << " = " << px->maxProb().toInt() << endl;
	    /* TEMPORARILY DISABLE
	      if ( FOREST )
	      fprintf ( stdout, "%d %s:%s{%s} %d : %d %s %d = %d\n",
	      i, g.second.first.getString().c_str(), g.second.second.getString().c_str(), g.second.third.getString().c_str(), i+1,
	      i, pw->getString().c_str(), i+1, w.getProb(g.second.second,g.second.third).toInt() );
	    */
	  }
	}
      }
      i++;
    }
      
  

    // Fill chart with nonterminals...
    for ( int di=1; di<=n; di++ ) {
      cerr << "  " << di << endl;
      for ( int i=0; i<=n-di; i++ ) {
        int j=i+di;

        // consider the best children for each head, regardless of split point
        CPT1DModel<UDLC,LogProb> maxProb;
        for ( int k=i+1; k<=j-1; k++ ) {

          //// Check/fill the chart
          for ( MModel::const_iterator iudlclclc = modM.begin(); iudlclclc!=modM.end(); iudlclclc++ ) {
            UDLC udlcP = iudlclclc->first.first;
            LCLC lclc  = iudlclclc->first.second;
            UDLCLCLC udlclclc = UDLCLCLC(udlcP,lclc);

            D  dL = (udlcP.first.first==U_R) ? D(udlcP.first.second.toInt()+1) : D(udlcP.first.second.toInt());
            UD udL( U_L, dL );
            UD udR( U_R, udlcP.first.second );
            L  lLeft  = lclc.first.first;
            L  lRight = lclc.second.first;

            UDLC udlc1 = UDLC(udL,lclc.first);
            UDLC udlc2 = UDLC(udR,lclc.second);
		
            //cerr  << i << "," << k << "," << j << " found M rule "<< gP << " -> " << lclc << endl;
            const ChartCell& x1 = axChart.get(i,k).get(udlc1);
            const ChartCell& x2 = axChart.get(k,j).get(udlc2);
            if ( x1!=ChartCell() && x2!=ChartCell() ) {
              //cerr << " binary possible! " << i << " " << k << " " << j << " " << udlcP
              //<< " -> " << x1.getG().first << " " << x2.getG().first << " with matrices\n  e1="
              //<< x1.getE() << "  and e2=" << x2.getE() << endl;
              //cerr <<" chain of mults starts with: M"<<udlclclc<<MModel::hM.get(udlclclc)
              //<< "Lleft "<<udlc1.second.first<< LModel::hL.get(lLeft)<< "Eleft"<<x1.getE()
              //<< "Lright "<<udlc2.second.first<< LModel::hL.get(lRight)<< "Eright"<< x2.getE()<<endl;

              // the actual multiplication.  '&' is overloaded as pt-by-pt multiplication
              Evec e = MModel::hM.get(udlclclc)
                & ( LModel::hL.get(lLeft)  * x1.getE() ) //* diag( LModel::hL.get(lLeft)  * x1.getE() )
                & ( LModel::hL.get(lRight) * x2.getE() ); //* diag( LModel::hL.get(lRight) * x2.getE() )  *  N_1;
              //cerr<< "  yields "<< e <<endl;
              //if ( FOREST )
              //  fprintf ( stdout, "%d %s %d : %d %s %d %s %d = %d\n",
              //            i, gP.getString().c_str(), j,
              //            i, g1.getString().c_str(), k, g2.getString().c_str(), j, pr.toInt() );
              //if ( LogProb(e.infnorm())>maxProb.getProb(udlcP) && !(e==IndexedVector()) ) {
              if ( LogProb( (GModel::hGr.get(udlcP)*e).get(0,0) )>maxProb.getProb(udlcP) && !(e==IndexedVector()) ) {
                //if (maxProb.getProb(udlcP)==LogProb()) cerr<<"  brand new probability for this constituent "<<udlcP<<"..."<<endl;
                //else if (LogProb(e.infnorm())>maxProb.getProb(udlcP)) cerr<<"  old probability for this constituent "<<udlcP<<" = "<<maxProb.getProb(udlcP).toInt()<<", replacing with "<<LogProb(e.infnorm()).toInt()<<endl;
                ChartCell& x = axChart.set(i,j).set(udlcP);
                x = ChartCell(G(udlcP,e),k,x1,x2,LogProb(e.infnorm()));
                //maxProb.setProb(udlcP) = LogProb(e.infnorm());
                maxProb.setProb(udlcP) = LogProb( (GModel::hGr.get(udlcP)*e).get(0,0) );
                //tryUnary ( axChart, i, j, x, modGgivG );
                if ( NOISY )
                  cerr << "      binary match! " << i << " " << k << " " << j << " " << udlcP
                       << " -> " << udlc1 << " " << udlc2 << " has max "
                       << x1.maxProb() << "*" << x2.maxProb() << " * M,L,L " 
                       << "max= " << LogProb(e.infnorm()) << endl;
              }
            }
          }
        }
      }
    }

    /*
      if ( FOREST ) {

      //ModeledC c;
      GModel::IterVal gr;
      for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) )
      if ( axChart.get(0,n).get(gr).getProb()*modGr.getProb(gr) != LogProb() ) {
      axChart.set(0,n).set(gr).setRooted();
      }

      for ( int di=n; di>=1; di-- ) {
      //cerr << "  " << di << endl;
      for ( int i=0; i<=n-di; i++ ) {
      int j=i+di;
      for ( MModel::const_iterator igr = modM.begin(); igr!=modM.end(); igr++ ) {
      G gP = igr->first.getX1();

      const ChartCell& x  = axChart.get(i,j).get(gP);
      if ( x.getRooted() ) {
      for ( int k=i+1; k<=j-1; k++ ) {
      Evec eP = Evec(gP.second.third);
		
      D  dL = (gP.first.first==U_R) ? D(gP.first.second.toInt()+1) : D(gP.first.second.toInt());
      UD udL( U_L, dL );
      UD udR( U_R, gP.first.second );
		
      MModel::IterVal ilclc;
      LModel::IterVal ieLeft;
      LModel::IterVal ieRight;
		
      for ( bool bg=modM.setFirst(ilclc,gP); bg; bg=modM.setNext(ilclc,gP) ) {
		  
      L lLeft  = ilclc.first.first;
      L lRight = ilclc.second.first;
		  
      for ( bool ble=modL.setFirst(ieLeft,lLeft,eP); ble; ble=modL.setNext(ieLeft,lLeft,eP) ) {
      //cerr<<"   iter over eLeft = "<<ieLeft<<endl;
      for ( bool ble=modL.setFirst(ieRight,lRight,eP); ble; ble=modL.setNext(ieRight,lRight,eP) ) {
      //cerr<<"   iter over eRight = "<<ieRight<<endl;
		      
      G g1 = G(udL,LCE(ilclc.first.first,ilclc.first.second,ieLeft));
      G g2 = G(udR,LCE(ilclc.second.first,ilclc.second.second,ieRight));
		      
      //cerr  << i << "," << k << "," << j << " found GG rule "<< gP << " -> " << gg<< endl;
      ChartCell& x1 = axChart.set(i,k).set(g1);
      ChartCell& x2 = axChart.set(k,j).set(g2);
      if ( x1!=ChartCell() && x2!=ChartCell() ) {
      x1.setRooted();
      x2.setRooted();
      LogProb pr = x1.getProb() * x2.getProb()
      * LogProb(modM.getProb(ilclc,gP)) * LogProb(modL.getProb(ieLeft,lLeft,eP)) * LogProb(modL.getProb(ieRight,lRight,eP));
      fprintf ( stdout, "%d %s:%s{%s} %d : %d %s:%s{%s} %d %s:%s{%s} %d = %d\n",
      i, gP.second.first.getString().c_str(),gP.second.second.getString().c_str(), gP.second.third.getString().c_str(), j,
      i, g1.second.first.getString().c_str(),g1.second.second.getString().c_str(), g1.second.third.getString().c_str(), 
      k, g2.second.first.getString().c_str(),g2.second.second.getString().c_str(), g2.second.third.getString().c_str(), j, pr.toInt() );
      }
      }
      }
      }
      }
      }
      }
      }
      }
      cout << "-" << endl;

      } else */ 
    {
      // Print best...
      LogProb         prBest=LogProb();
      UDLC            udlcBest;

      //for (SimpleHash<UDLC,ChartCell>::const_iterator it=axChart.get(0,n).begin(); !(it==axChart.get(0,n).end()); it++) {
      //cerr<< "Rooted node, P("<<it->first<<")="<<axChart.get(0,n).get(it->first).getE()<<endl;
      //}

      //GModel::IterVal gr;
      //for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) ) {
      for (GrModel::const_iterator iudlc=modGr.begin(); iudlc!=modGr.end(); iudlc++) {
	//for (SimpleHash<UDLC,ChartCell>::const_iterator iudlc=axChart.get(0,n).begin(); !(iudlc==axChart.get(0,n).end()); iudlc++) {
	UDLC udlc ( UD(iudlc->first.first), LC(iudlc->first.second) );
	//cerr<< "Gr Root, P("<<iudlc->first<<")="<<GrModel::hGr.get(udlc)<<endl;
	if ( !axChart.get(0,n).contains(udlc) ) { continue; }
	//cerr<<endl;;
	Evec er = GrModel::hGr.get(udlc) * axChart.get(0,n).get(udlc).getE();
	//cerr<<" ...matches chart-topper root P("<<udlc<<")=";
	//cerr<<axChart.get(0,n).get(iudlc->first).getE()<<"    yields "<<er;
        if ( LogProb()==prBest || LogProb(er.infnorm())>prBest) {
	  udlcBest  = udlc;
	  prBest = er.infnorm();
	}
	//err<<endl;
      }
      if ( prBest>LogProb() ) {
	List<W> lw2 = lw;
        axChart.get(0,n).get(udlcBest).writeBest(stdout,lw);
	if (NOISY) {
	  cout<<endl;
	  axChart.get(0,n).get(udlcBest).writePath(stderr,lw2);
	  cerr << endl<<"      Probability="<<prBest;
	}
      }
      else
        cout << "[ERROR failed]";
      cout << endl;
    }

    // clear caches
    //mLxE.clear();
    //mMxLExLE.clear();

  }

  //if (nArgs>2) fin.close();
  //if (NOISY) {
  //  cerr << " trying to dump modGGgivG\n";
  //  modGGgivG.dump(cerr,"GG");
  //}


}

