
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Str
open String
open Trees


(* formatting exception *)
exception WrongFormat of string;;


(* get dat items *)
let rec write_dat_items = function
    ChildList(Term(sP),ChildList(lchL,ChildList(lchR,End))) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let uP = matched_group 4 sP in
      let dP = matched_group 5 sP in
      let (lL,cL,hL) = write_dat_items lchL in
      let (lR,cR,hR) = write_dat_items lchR in
      print_endline ("G : "^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"} = 1");
      print_endline ("M "^uP^" "^dP^" "^lP^":"^cP^"{"^hP^"} : "^lL^":"^cL^" "^lR^":"^cR^" = 1");
      print_endline ("L "^lL^" "^hP^" : "^hL^" = 1");
      print_endline ("L "^lR^" "^hP^" : "^hR^" = 1");
      (lP,cP,hP)
  | ChildList(Term(sP),ChildList(Term(_) as px,End)) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\^\\([LR]\\),\\([0-9]\\)") sP 0 ->
      let l = matched_group 1 sP in
      let c = matched_group 2 sP in
      let h = matched_group 3 sP in
      let u = matched_group 4 sP in
      let d = matched_group 5 sP in
      let (p,x,_) = write_dat_items px in
      print_endline ("G : "^u^" "^d^" "^l^":"^c^"{"^h^"} = 1");
      print_endline ("M "^u^" "^d^" "^l^":"^c^"{"^h^"} : -:- -:- = 1");
      print_endline ("H "^c^" "^h^" : "^h^" = 1");
      print_endline ("Cp "^p^" : "^c^" = 1");
      print_endline ("Pw "^x^" : "^p^" = 1");
      print_endline ("Pc "^c^" : "^p^" = 1");
      print_endline ("P : "^p^" = 1");
      (* print_endline ("W : "^x^" = 1"); *)
      (l,c,h)
  | ChildList(Term(sP),_   ) -> raise (WrongFormat sP)
  | ChildList(lch,     End ) -> write_dat_items(lch)
  | ChildList(lchL,    lchR) -> raise (WrongFormat "unlabeled binary branch")
  | Term(s) when string_match (regexp "\\(.*\\)#\\(.*\\)") s 0 ->
      (matched_group 1 s, matched_group 2 s, "")
  | Term(s)                  -> raise (WrongFormat s)
  | End                      -> raise (WrongFormat "unexpected end");;


(* read loop *)
try
  while true do
    let s = input_line stdin in
    let r,t = tree_of_string s in
    let (l,c,h) = write_dat_items t in
    print_endline ("Gr : "^l^":"^c^"{"^h^"} = 1");
    ()
  done;
  None
with
  End_of_file -> None
;;



