///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"

char psX[]="";
char psComma[]=",";
char psSemi[]=";";
char psSemiSemi[]=";;";
char psDashDiamondDash[]="-<>-";
//char psBar[]="|";
//char psOpenBrace[]="{";
//char psCloseBrace[]="}";
char psLangle[]="<";
char psRangle[]=">";
char psLbrack[]="[";
char psRbrack[]="]";

const char* BEG_STATE = "END/END|END;-/-|-;-/-|-;-/-|-";
const char* END_STATE = "END/END|END;-/-|-;-/-|-;-/-|-";


////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// Simple Variables

//// D: depth (input only, to HHMM models)...
DiscreteDomain<char> domD;
typedef DiscreteDomainRV<char,domD> D;
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");

//// F: final-state...
DiscreteDomain<char> domF;
typedef DiscreteDomainRV<char,domF> F;
const F F_0("0");
const F F_1("1");

//// G: next value after slash (for `shift' expansions, to ignore material to left and right of expanded symbol)...
DiscreteDomain<int> domG;
typedef DiscreteDomainRV<int,domG> G;
const G G_0("<\?\?>");

/*
//// C: syntactic category...
DiscreteDomain<int> domC;
typedef DiscreteDomainRV<int,domC> C;
const C C_NIL("-/-|-");
const C C_TOP("ROOT/S|S");
*/

//////////////////////////////////////// Deterministic Variables

//// C: syntactic category...
DiscreteDomain<int> domC;
class C : public DiscreteDomainRV<int,domC> {
 private:
  static SimpleHash<C,G> hToG;
  void calcDetModels ( string s ) {
    if (!hToG.contains(*this)) {
      size_t i=s.find('|');
      assert(i!=string::npos); 
      hToG.set(*this) = G(s.substr(i+1).c_str());
    }
  }
 public:
  C ( )                : DiscreteDomainRV<int,domC> ( )    { }
  C ( const char* ps ) : DiscreteDomainRV<int,domC> ( ps ) { calcDetModels(ps); }
  //C ( string s ) : DiscreteDomainRV<int,domC> ( s )  { calcDetModels(s); }
  G getG ( ) const { return hToG.get(*this); }
  friend pair<StringInput,C*> operator>> ( StringInput si, C& m ) { return pair<StringInput,C*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,C*> delimbuff, const char* psD ) {
    if ( delimbuff.first == NULL ) return NULL;
    StringInput si=delimbuff.first>>(DiscreteDomainRV<int,domC>&)*delimbuff.second>>psD;
    delimbuff.second->calcDetModels(delimbuff.second->getString()); return si; }
};
SimpleHash<C,G> C::hToG;
#define C_NIL C("-/-|-")
#define C_TOP C("ROOT/S|S")
//const C C_NIL("-/-|-");
//const C C_TOP("ROOT/S|S");

//////////////////////////////////////// Deterministic models...

/*
//// G: next value after slash (for `shift' expansions, to ignore material to left and right of expanded symbol)...
class GdetCModel : public CPT2DModel<G,C,LogProb> {
 public:
  bool readField ( string s ) {
    if (!hasDeterm(C(s.c_str()))) {
      size_t i=s.find('|');
      assert(i!=string::npos); 
      setProb( G(s.substr(i+1).c_str()), C(s.c_str()) ) = LogProb(1.0);
      //cerr<<"G "<<s.substr(i+1)<<" "<<s<<endl;
    }
    return false;
  }
};
GdetCModel mGdetC;
*/


typedef C Cnormal;
const Cnormal CNORMAL_0("\?/\?|\?");


//////////////////////////////////////// Joint Variables

//// R: collection of syntactic variables at all depths in each `reduce' phase...
typedef DelimitedStaticSafeArray<4,psSemi,F> R;

//// S: collection of syntactic variables at all depths in each `shift' phase...
class S : public DelimitedStaticSafeArray<4,psSemi,C> {
 public:
  operator G()  const { return ( ( (get(3)!=C_NIL) ? get(3) :
                                      (get(2)!=C_NIL) ? get(2) :
                                      (get(1)!=C_NIL) ? get(1) : get(0) ).getG() ); } //mPexpdetP.getDeterm(getSub2());} 
  //operator G()  const {return mGdetC.getDeterm ((get(3)!=C_NIL)?get(3):(get(2)!=C_NIL)?get(2):(get(1)!=C_NIL)?get(1):get(0));}
  bool compareFinal ( const S& s ) const { return(*this==s); }
};

//// H: the set of all (marginalized) reduce and (modeled) shift variables in the HHMM...
class H : public DelimitedJoint2DRV<psX,R,psDashDiamondDash,S,psX>
{ public:
  operator R() const {return getSub1();}
  operator S() const {return getSub2();}
  operator D() const {return ( (getSub1().get(3)==F_0) ? D_4 :
                               (getSub1().get(2)==F_0) ? D_3 :
                               (getSub1().get(1)==F_0) ? D_2 :
                               (getSub1().get(0)==F_0) ? D_1 : D_0 );}
};


////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////// "Wrapper" models for individual RVs...

//// Model of F given D and G and C(prev)
typedef CPT4DModel<F,D,G,C,LogProb> FcptModel;
////CPT4DModel<F,D,G,C,LogProb> modFgivDGC ("F_giv_D,G,C");
//FcptModel mFcpt;

//// Model of F given D and F and C and C(prev)
class FModel {  //: public Generic5DModel<F,D,F,C,C,LogProb> {
 private:
  FcptModel mFcpt;
 public:
  static bool F_ROOT_OBS;
  typedef FcptModel::IterVal IterVal;
  bool    setFirst (       FModel::IterVal& f, const D& d, const F& fD, const C& cP, const C& cU ) const {
    if (fD==F_1 && !mFcpt.setFirst(f,d,cU.getG(),cP)) cerr<<"ERROR: no F "<<d<<" "<<cU.getG()<<" "<<cP<<"\n";
    if (fD==F_1) return mFcpt.setFirst(f,d,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    f=F_0; return true; }
  bool    setNext  (       FModel::IterVal& f, const D& d, const F& fD, const C& cP, const C& cU ) const {
    if (fD==F_1) return mFcpt.setNext(f,d,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    return false; }
  LogProb getProb  ( const FModel::IterVal& f, const D& d, const F& fD, const C& cP, const C& cU ) const {
    if (d==D_1 && F_ROOT_OBS==false && f==F_1) return LogProb() ;
    if (d==D_1 && F_ROOT_OBS==true  && f!=F_1) return LogProb() ;
    if (fD==F_1) return mFcpt.getProb(f,d,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    return (f==F_0) ? LogProb(1.0) : LogProb(); }
  friend pair<StringInput,FModel*> operator>> ( StringInput si, FModel& m ) { return pair<StringInput,FModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,FModel*> delimbuff, const char* psD ) { return delimbuff.first>>"F ">>delimbuff.second->mFcpt>>psD; }
};
bool FModel::F_ROOT_OBS = false;
//FModel mF;
////typedef Modeled5DRV<typeof(modF),modF> ModeledF;


//// Initialization model of C given D and Cnormal (from above)
typedef CPT3DModel<C,D,Cnormal,LogProb> CicptModel;
//CicptModel mCicpt;
////CPT3DModel<C,D,Cnormal,LogProb> modCgivDCnormalinit("C_giv_D,Cnormal-init");
////typedef Modeled3DRV<typeof(modCgivDCnormalinit),modCgivDCnormalinit> ModeledCi;

//// Transition model of C given D and G (from above) and C (from previous)
typedef CPT5DModel<C,D,F,G,C,LogProb> CtcptModel;
//CtcptModel mCtcpt;
////CPT5DModel<C,D,F,G,C,LogProb> modCgivDFGCtrans("C_giv_D,F,G,C-trans");
////typedef Modeled5DRV<typeof(modCgivDFGCtrans),modCgivDFGCtrans> ModeledCt;


//// Model of C given D and F and F and C(from prev) and C(from above)
class CModel {  //: public Generic6DModel<C,D,F,F,C,C,LogProb> {
 private:
  CicptModel mCicpt;
  CtcptModel mCtcpt;
 public:
  typedef CicptModel::IterVal IterVal;
  //typedef ComplexDoubleIteratedModeledRV<CicptModel::IterVal,CtcptModel::IterVal> IterVal;
  bool    setFirst (       CModel::IterVal& c, const D& d, const F& fD, const F& f, const C& cP, const C& cU ) const {
    //CicptModel::IterVal& ci = c.iter_first;
    //CtcptModel::IterVal& ct = c.iter_second;
    if (fD==F_1) {
      if (f==F_1) {
        ////if (DetModeledY(DetModeledCsing(cU))==Y_1) {c=DetModeledCsing(cU); return true;}
        //cout << d.getString() << cU.getString() << " -- ";
        bool b= mCicpt.setFirst(c,d,cU); //DetModeledCnormal(cU));
        if (!b) cerr<<"ERROR: no Ci "<<d<<" "<<cU<<"\n";
        //cout << "X" << endl;
        return b;
      }
      if (!mCtcpt.setFirst(c,d,f,cU.getG(),cP)) cerr<<"ERROR: no Ct "<<d<<" "<<f<<" "<<cU.getG()<<" "<<cP<<"\n";
      return mCtcpt.setFirst(c,d,f,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    }
    c=cP; return true;
  }
  bool    setNext  (       CModel::IterVal& c, const D& d, const F& fD, const F& f, const C& cP, const C& cU ) const {
    //CicptModel::IterVal& ci = c.iter_first;
    //CtcptModel::IterVal& ct = c.iter_second;
    if (fD==F_1) {
      if (f==F_1) {
        //if (DetModeledY(DetModeledCsing(cU))==Y_1) return false;
        return mCicpt.setNext(c,d,cU); //DetModeledCnormal(cU));
      }
      return mCtcpt.setNext(c,d,f,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    }
    return false;
  }
  LogProb getProb  ( const CModel::IterVal& c, const D& d, const F& fD, const F& f, const C& cP, const C& cU ) const {
    //const CicptModel::IterVal& ci = c.iter_first;
    //const CtcptModel::IterVal& ct = c.iter_second;
    LogProb pLE,pC;
    if (fD==F_1) {
      if (f==F_1) {
        //if (DetModeledY(DetModeledCsing(cU))==Y_1) return (l==L_NONE && e==eU && c==DetModeledCsing(cU)) ? LogProb(1.0) : LogProb();;
        return mCicpt.getProb(c,d,cU); //DetModeledCnormal(cU));
      }
      return mCtcpt.getProb(c,d,f,cU.getG()/*mGdetC.getDeterm(cU)*/,cP);
    }
    return (c==cP) ? LogProb(1.0) : LogProb();
  }
  friend pair<StringInput,CModel*> operator>> ( StringInput si, CModel& m ) { return pair<StringInput,CModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,CModel*> delimbuff, const char* psD ) {
    StringInput si;
    return ( (si=delimbuff.first>>"Ci ">>delimbuff.second->mCicpt>>psD)!=NULL ||
             (si=delimbuff.first>>"Ct ">>delimbuff.second->mCtcpt>>psD)!=NULL ) ? si : StringInput(NULL);
  }
};
//CModel mC;
////typedef Modeled6DRV<typeof(modC),modC> ModeledC;


//////////////////////////////////////// Joint models...

//////////////////// Reduce phase...

//// Model of R given S
class RModel : public SingleFactoredModel<FModel> {  //: public Generic2DModel<R,S,LogProb> {
 public:
  typedef ComplexArrayIteratedModeledRV<FModel::IterVal,psSemi,4> IterVal;
  bool setFirst ( RModel::IterVal& r, const S& sP ) const {
    const FModel& mF = getM1();
    const C  cP0 = C_TOP;
    const C& cP1 = sP.get(0);
    const C& cP2 = sP.get(1);
    const C& cP3 = sP.get(2);
    const C& cP4 = sP.get(3);
    FModel::IterVal  f5 = F_1;
    FModel::IterVal& f4 = r.iter_array.set(3);
    FModel::IterVal& f3 = r.iter_array.set(2);
    FModel::IterVal& f2 = r.iter_array.set(1);
    FModel::IterVal& f1 = r.iter_array.set(0);
    return ( mF.setFirst(f4,4,f5,cP4,cP3) && mF.setFirst(f3,3,f4,cP3,cP2) && mF.setFirst(f2,2,f3,cP2,cP1) && mF.setFirst(f1,1,f2,cP1,cP0) );
  }
  bool setNext ( RModel::IterVal& r, const S& sP ) const {
    const FModel& mF = getM1();
    const C  cP0 = C_TOP;
    const C& cP1 = sP.get(0);
    const C& cP2 = sP.get(1);
    const C& cP3 = sP.get(2);
    const C& cP4 = sP.get(3);
    FModel::IterVal  f5 = F_1;
    FModel::IterVal& f4 = r.iter_array.set(3);
    FModel::IterVal& f3 = r.iter_array.set(2);
    FModel::IterVal& f2 = r.iter_array.set(1);
    FModel::IterVal& f1 = r.iter_array.set(0);
    return ( (                                                                                                 mF.setNext(f1,1,f2,cP1,cP0) ) ||
             (                                                                 mF.setNext(f2,2,f3,cP2,cP1) && mF.setFirst(f1,1,f2,cP1,cP0) ) ||
             (                                 mF.setNext(f3,3,f4,cP3,cP2) && mF.setFirst(f2,2,f3,cP2,cP1) && mF.setFirst(f1,1,f2,cP1,cP0) ) ||
             ( mF.setNext(f4,4,f5,cP4,cP3) && mF.setFirst(f3,3,f4,cP3,cP2) && mF.setFirst(f2,2,f3,cP2,cP1) && mF.setFirst(f1,1,f2,cP1,cP0) ) );
  }
  LogProb getProb ( const RModel::IterVal& r, const S& sP ) const {
    const FModel& mF = getM1();
    const C  cP0 = C_TOP;
    const C& cP1 = sP.get(0);
    const C& cP2 = sP.get(1);
    const C& cP3 = sP.get(2);
    const C& cP4 = sP.get(3);
    const FModel::IterVal  f5 = F_1;
    const FModel::IterVal& f4 = r.iter_array.get(3);
    const FModel::IterVal& f3 = r.iter_array.get(2);
    const FModel::IterVal& f2 = r.iter_array.get(1);
    const FModel::IterVal& f1 = r.iter_array.get(0);
    LogProb p1,p2,p3,p4;
    return ( (p4=mF.getProb(f4,4,f5,cP4,cP3)) * (p3=mF.getProb(f3,3,f4,cP3,cP2)) * (p2=mF.getProb(f2,2,f3,cP2,cP1)) * (p1=mF.getProb(f1,1,f2,cP1,cP0)) );
  }
};
//RModel mR;
////typedef Modeled2DRV<typeof(modRgivS),modRgivS> ModeledR;


//////////////////// Shift phase...

//// Model of S given R and S
class SModel : public SingleFactoredModel<CModel> {  //: public Generic3DModel<S,R,S,LogProb> {
 public:
  typedef ComplexArrayIteratedModeledRV<CModel::IterVal,psSemi,4> IterVal;
  bool setFirst ( SModel::IterVal& s, const RModel::IterVal& r, const S& sP ) const {
    const CModel& mC = getM1();
    const C&  cP1 = sP.get(0);
    const C&  cP2 = sP.get(1);
    const C&  cP3 = sP.get(2);
    const C&  cP4 = sP.get(3);
    const FModel::IterVal   f5  = F_1;
    const FModel::IterVal&  f4  = r.iter_array.get(3);
    const FModel::IterVal&  f3  = r.iter_array.get(2);
    const FModel::IterVal&  f2  = r.iter_array.get(1);
    const FModel::IterVal&  f1  = r.iter_array.get(0);
    CModel::IterVal  c0 = C_TOP;
    CModel::IterVal& c1 = s.iter_array.set(0);
    CModel::IterVal& c2 = s.iter_array.set(1);
    CModel::IterVal& c3 = s.iter_array.set(2);
    CModel::IterVal& c4 = s.iter_array.set(3);
    return ( mC.setFirst(c1,1,f2,f1,cP1,c0) && mC.setFirst(c2,2,f3,f2,cP2,c1) && mC.setFirst(c3,3,f4,f3,cP3,c2) && mC.setFirst(c4,4,f5,f4,cP4,c3) );
  }
  bool setNext ( SModel::IterVal& s, const RModel::IterVal& r, const S& sP ) const {
    const CModel& mC = getM1();
    const C&  cP1 = sP.get(0);
    const C&  cP2 = sP.get(1);
    const C&  cP3 = sP.get(2);
    const C&  cP4 = sP.get(3);
    const FModel::IterVal   f5  = F_1;
    const FModel::IterVal&  f4  = r.iter_array.get(3);
    const FModel::IterVal&  f3  = r.iter_array.get(2);
    const FModel::IterVal&  f2  = r.iter_array.get(1);
    const FModel::IterVal&  f1  = r.iter_array.get(0);
    CModel::IterVal  c0 = C_TOP;
    CModel::IterVal& c1 = s.iter_array.set(0);
    CModel::IterVal& c2 = s.iter_array.set(1);
    CModel::IterVal& c3 = s.iter_array.set(2);
    CModel::IterVal& c4 = s.iter_array.set(3);
    return ( (                                                                                                       mC.setNext(c4,4,f5,f4,cP4,c3) ) ||
             (                                                                     mC.setNext(c3,3,f4,f3,cP3,c2) && mC.setFirst(c4,4,f5,f4,cP4,c3) ) ||
             (                                   mC.setNext(c2,2,f3,f2,cP2,c1) && mC.setFirst(c3,3,f4,f3,cP3,c2) && mC.setFirst(c4,4,f5,f4,cP4,c3) ) ||
             ( mC.setNext(c1,1,f2,f1,cP1,c0) && mC.setFirst(c2,2,f3,f2,cP2,c1) && mC.setFirst(c3,3,f4,f3,cP3,c2) && mC.setFirst(c4,4,f5,f4,cP4,c3) ) );
  }
  LogProb getProb ( const SModel::IterVal& s, const RModel::IterVal& r, const S& sP ) const {
    const CModel& mC = getM1();
    const C&  cP1 = sP.get(0);
    const C&  cP2 = sP.get(1);
    const C&  cP3 = sP.get(2);
    const C&  cP4 = sP.get(3);
    const FModel::IterVal   f5  = F_1;
    const FModel::IterVal&  f4  = r.iter_array.get(3);
    const FModel::IterVal&  f3  = r.iter_array.get(2);
    const FModel::IterVal&  f2  = r.iter_array.get(1);
    const FModel::IterVal&  f1  = r.iter_array.get(0);
    const CModel::IterVal  c0 = C_TOP;
    const CModel::IterVal& c1 = s.iter_array.get(0);
    const CModel::IterVal& c2 = s.iter_array.get(1);
    const CModel::IterVal& c3 = s.iter_array.get(2);
    const CModel::IterVal& c4 = s.iter_array.get(3);
    LogProb p1,p2,p3,p4;
    return ( (p1=mC.getProb(c1,1,f2,f1,cP1,c0)) * (p2=mC.getProb(c2,2,f3,f2,cP2,c1)) * (p3=mC.getProb(c3,3,f4,f3,cP3,c2)) * (p4=mC.getProb(c4,4,f5,f4,cP4,c3)) );
  }
};
//SModel mS;
////typedef Modeled3DRV<typeof(modSgivRS),modSgivRS> ModeledS;


//////////////////// Overall...

//// Model of H=R,S given S
class HModel : public DoubleFactoredModel<RModel,SModel> {  //: public ComplexDoubleModel<RModel,SModel> {
 public:
  typedef ComplexDoubleIteratedModeledRV<psLbrack,RModel::IterVal,psRbrack,SModel::IterVal,psX> IterVal;
  S& setTrellDat ( S& s, const HModel::IterVal& h ) const {
    for(int i=0;i<4;i++)
      s.set(i)=h.iter_second.iter_array.get(i);
    return s;
  }
  R setBackDat ( const HModel::IterVal& h ) const {
//    return h.iter_first.iter_array.get(0);
    R r;
    for(int i=0;i<4;i++)
      r.set(i)=h.iter_first.iter_array.get(i);
    return r;
//    return ( (h.iter_first.iter_array.get(3)==F_0) ? D_4 :
//             (h.iter_first.iter_array.get(2)==F_0) ? D_3 :
//             (h.iter_first.iter_array.get(1)==F_0) ? D_2 :
//             (h.iter_first.iter_array.get(0)==F_0) ? D_1 : D_0 );
  }
  bool setFirst ( HModel::IterVal& h, const S& sP ) const {
    const RModel& mR = getM1();
    const SModel& mS = getM2();
    RModel::IterVal& r = h.iter_first;
    SModel::IterVal& s = h.iter_second;
    return ( mR.setFirst(r,sP) && mS.setFirst(s,r,sP) );
  }
  bool setNext ( HModel::IterVal& h, const S& sP ) const {
    const RModel& mR = getM1();
    const SModel& mS = getM2();
    RModel::IterVal& r = h.iter_first;
    SModel::IterVal& s = h.iter_second;
    return ( (                      mS.setNext(s,r,sP) ) ||
             ( mR.setNext(r,sP) && mS.setFirst(s,r,sP) ) );
  }
  LogProb getProb ( const HModel::IterVal& h, const S& sP ) const {
    const RModel& mR = getM1();
    const SModel& mS = getM2();
    const RModel::IterVal& r = h.iter_first;
    const SModel::IterVal& s = h.iter_second;
    return ( mR.getProb(r,sP) * mS.getProb(s,r,sP) );
  }
};
//HModel mH;


/*
//// Model of H given S
class HModel : public Generic2DModel<H,S,LogProb> {
 public:
  bool setFirst ( H& h, const S& sP ) const {
    ModeledR& r = (h.setSub1());
    ModeledS& s = (h.setSub2());
    return ( r.setFirst(sP) && s.setFirst(r,sP) );
  }
  bool setNext ( H& h, const S& sP ) const {
    ModeledR& r = (h.setSub1());
    ModeledS& s = (h.setSub2());
    return ( (                   s.setNext(r,sP) ) ||
             ( r.setNext(sP) && s.setFirst(r,sP) ) );
  }
  LogProb getProb ( const H& h, const S& sP ) const {
    const ModeledR& r = (h.getSub1());
    const ModeledS& s = (h.getSub2());
    return ( r.getProb(sP) * s.getProb(r,sP) );
  }
};
HModel modHgivH;
//typedef Modeled2DRV<typeof(modHgivH),modHgivH> ModeledH;
*/

////////////////////////////////////////////////////////////////////////////////
//
//  Reader
//
////////////////////////////////////////////////////////////////////////////////

/*
bool readHiddenFields ( Array<char*>& aps ) {
  return ( (0==strcmp(aps[0],"Ci") ) || //&& mGdetC.readField(aps[3]) ) ||
           (0==strcmp(aps[0],"Ct") ) || //&& mGdetC.readField(aps[5]) ) ||
           (0==strcmp(aps[0],"F")  && mFcpt.readFields(aps)       ) ||
           (0==strcmp(aps[0],"Ci") && mCicpt.readFields(aps) ) ||   //&& DetModeledG(aps[3])!=G_0) ||   //&& DetModeledClack(aps[3])!=CNORMAL_0) ||
           (0==strcmp(aps[0],"Ct") && mCtcpt.readFields(aps) ) ); } //&& DetModeledG(aps[5])!=G_0) ); } //&& DetModeledClack(aps[5])!=CNORMAL_0) ); }
*/
