/*
 * Decompiled with CFR 0.152.
 */
package babel.util.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class FileList
implements Enumeration<InputStream> {
    protected String[] m_listOfFiles;
    protected int m_current;
    protected File m_dir;
    protected FilenameFilter m_nameFilter;

    public FileList(String dir) {
        this(dir, null);
    }

    public FileList(String dir, FilenameFilter nameFilter) {
        this.m_nameFilter = nameFilter;
        this.m_dir = new File(dir);
        this.m_current = 0;
    }

    public String getDir() {
        return this.m_dir.getAbsolutePath();
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_listOfFiles != null && this.m_current < this.m_listOfFiles.length;
    }

    @Override
    public InputStream nextElement() {
        FileInputStream in = null;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException("No more files.");
        }
        String nextElement = this.m_listOfFiles[this.m_current++];
        try {
            in = new FileInputStream(nextElement);
        }
        catch (FileNotFoundException e) {
            System.err.println("ListOfFiles: Can't open " + nextElement);
        }
        return in;
    }

    public String[] getFileNames() {
        return this.m_listOfFiles;
    }

    public String getFileName(int index) {
        return this.m_listOfFiles != null && index >= 0 && index < this.m_listOfFiles.length ? this.m_listOfFiles[index] : null;
    }

    public int size() {
        return this.m_listOfFiles == null ? -1 : this.m_listOfFiles.length;
    }

    public void gather() {
        this.m_listOfFiles = this.m_nameFilter == null ? this.m_dir.list() : this.m_dir.list(this.m_nameFilter);
        this.m_current = 0;
        int i = 0;
        while (this.m_listOfFiles != null && i < this.m_listOfFiles.length) {
            this.m_listOfFiles[i] = String.valueOf(this.m_dir.getAbsolutePath()) + File.separator + this.m_listOfFiles[i];
            ++i;
        }
    }

    public void gather(int depth) {
        this.m_listOfFiles = null;
        this.m_current = 0;
        LinkedList<String> list = this.recursiveGather(depth, this.m_dir);
        if (list.size() != 0) {
            this.m_listOfFiles = new String[list.size()];
            list.toArray(this.m_listOfFiles);
        }
    }

    protected LinkedList<String> recursiveGather(int depth, File parent) {
        LinkedList<String> curList = new LinkedList<String>();
        if (depth > 0) {
            File[] fileArray = parent.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    curList.addAll(this.recursiveGather(depth - 1, file));
                } else if (this.m_nameFilter == null || this.m_nameFilter.accept(parent, file.getName())) {
                    curList.add(String.valueOf(parent.getAbsolutePath()) + File.separator + file.getName());
                }
                ++n2;
            }
        }
        return curList;
    }

    public void sort() {
        if (this.m_listOfFiles != null) {
            Arrays.sort(this.m_listOfFiles);
        }
    }
}

