/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.context;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.context.Context;
import babel.content.eqclasses.properties.type.Type;
import babel.ranking.scorers.context.DictScorer;
import babel.util.dict.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FungS2Scorer
extends DictScorer {
    public static final Log LOG = LogFactory.getLog(FungS2Scorer.class);
    protected double m_srcMaxCount;
    protected double m_trgMaxCount;

    public FungS2Scorer(Dictionary dict, double srcMaxCount, double trgMaxCount) {
        super(dict);
        this.m_srcMaxCount = srcMaxCount;
        this.m_trgMaxCount = trgMaxCount;
        if (this.m_srcMaxCount == 0.0 | this.m_trgMaxCount == 0.0) {
            throw new IllegalArgumentException("Max count is zero");
        }
    }

    @Override
    public double score(EquivalenceClass srcEq, EquivalenceClass trgEq) {
        Context srcContext = (Context)srcEq.getProperty(Context.class.getName());
        Context trgContext = (Context)trgEq.getProperty(Context.class.getName());
        if (srcContext == null || trgContext == null || !srcContext.areContItemsScored() || !trgContext.areContItemsScored()) {
            throw new IllegalArgumentException("At leas one of the classes has no or unscored context.");
        }
        double score = 0.0;
        double score1 = 0.0;
        double score2 = 0.0;
        for (Context.ContextualItem srcCi : srcContext.getContextualItems()) {
            double w1 = srcCi.getScore();
            double w2 = 0.0;
            Context.ContextualItem trgCi = trgContext.getContextualItem(srcCi.getContextEqId());
            if (trgCi != null) {
                w2 = trgCi.getScore();
            }
            score1 += w2 * w2;
            score2 += w1 * w1;
            score += w2 * w1;
        }
        return score1 + score2 == 0.0 ? 0.0 : 2.0 * score / (score1 + score2);
    }

    @Override
    protected double scoreContItem(Context.ContextualItem contItem, Type.EqType type) {
        double tf = contItem.getContextCount();
        double idf = Math.log((type.equals((Object)Type.EqType.SOURCE) ? this.m_srcMaxCount : this.m_trgMaxCount) / (double)contItem.getCorpusCount()) + 1.0;
        return tf * idf;
    }
}

