/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.lshtime;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.LSHPropertyCollector;
import babel.content.eqclasses.properties.lshtime.LSHTimeDistribution;
import babel.content.eqclasses.properties.time.TimeDistribution;
import babel.util.jerboa.LSH;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSHTimeDistributionCollector
extends LSHPropertyCollector {
    private static final Log LOG = LogFactory.getLog(LSHTimeDistributionCollector.class);
    private static final LSH TIME_LSH = new LSH();

    public LSHTimeDistributionCollector(boolean removeOrigProp) {
        super(removeOrigProp);
    }

    @Override
    public void collectProperty(Set<? extends EquivalenceClass> eqClasses) throws Exception {
        HashMap<String, Double> features = new HashMap<String, Double>();
        int numUnscored = 0;
        for (EquivalenceClass equivalenceClass : eqClasses) {
            TimeDistribution distro = (TimeDistribution)equivalenceClass.getProperty(TimeDistribution.class.getName());
            if (distro == null || !distro.isNormalized()) {
                ++numUnscored;
                continue;
            }
            features.clear();
            HashMap<Integer, Double> bins = distro.getBins();
            for (Integer window : bins.keySet()) {
                features.put(window.toString(), bins.get(window));
            }
            equivalenceClass.setProperty(new LSHTimeDistribution(equivalenceClass, TIME_LSH.buildSignature(features)));
            if (!this.m_removeOrigProp) continue;
            equivalenceClass.removeProperty(TimeDistribution.class.getName());
        }
        if (numUnscored > 0) {
            LOG.error((Object)("Could not compute LSH signature for " + numUnscored + " equvalence classes (either missing or unnormalized distribution)."));
        }
    }
}

