/*
 * Decompiled with CFR 0.152.
 */
package babel.content.corpora.accessors;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.corpora.accessors.TemporalCorpusAccessor;
import babel.util.misc.FileList;
import babel.util.misc.RegExFileNameFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikiTempCorpusAccessor
extends TemporalCorpusAccessor {
    protected static final Log LOG = LogFactory.getLog(WikiTempCorpusAccessor.class);
    protected static final String DEFAULT_CHARSET = "UTF-8";
    protected int m_curFileNum;
    protected String m_encoding;
    protected FileList m_files;

    public WikiTempCorpusAccessor(String fileNameRegEx, String corpusDir, boolean oneSentPerLine) {
        this(fileNameRegEx, corpusDir, DEFAULT_CHARSET, oneSentPerLine);
    }

    public WikiTempCorpusAccessor(String fileNameRegEx, String corpusDir, String charset, boolean oneSentPerLine) {
        super(oneSentPerLine);
        this.resetFiles();
        this.resetDays();
        this.m_files = new FileList(corpusDir, new RegExFileNameFilter(fileNameRegEx));
        this.m_encoding = charset;
    }

    @Override
    public InputStreamReader getCorpusReader() {
        InputStreamReader retReader = null;
        this.m_files.gather(2);
        this.m_files.sort();
        LOG.info((Object)("Wikipedia Pages: " + this.m_files.size()));
        try {
            retReader = new InputStreamReader((InputStream)new SequenceInputStream(this.m_files), this.m_encoding);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return retReader;
    }

    @Override
    public CorpusAccessor.NamedInputStreamReader getCurFileReader() {
        CorpusAccessor.NamedInputStreamReader namedReader = null;
        try {
            if (this.m_curFileNum != -1) {
                String fileName = this.m_files.getFileName(this.m_curFileNum);
                int lastSlashIdx = fileName.lastIndexOf(47);
                String fileHandle = lastSlashIdx >= 0 ? fileName.substring(lastSlashIdx + 1) : fileName;
                namedReader = new CorpusAccessor.NamedInputStreamReader(fileHandle, new InputStreamReader((InputStream)new FileInputStream(fileName), this.m_encoding));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        return namedReader;
    }

    @Override
    public boolean nextFile() {
        boolean hasNext = false;
        if (this.m_curFileNum == -1) {
            this.m_files.gather(2);
            this.m_files.sort();
            hasNext = this.m_files.size() > 0;
            if (hasNext) {
                this.m_curFileNum = 0;
            }
        } else {
            hasNext = this.m_curFileNum + 1 < this.m_files.size();
            if (hasNext) {
                ++this.m_curFileNum;
            }
        }
        return hasNext;
    }

    @Override
    public boolean resetFiles() {
        this.m_curFileNum = -1;
        return true;
    }

    public FileList getFileList() {
        this.m_files.gather(2);
        this.m_files.sort();
        return this.m_files;
    }

    @Override
    public Date getCurDay() {
        return null;
    }

    @Override
    public InputStreamReader getCurDayReader() {
        InputStreamReader retReader = this.getCurFileReader().getReader();
        return retReader;
    }

    @Override
    public boolean nextDay() {
        return this.nextFile();
    }

    @Override
    public boolean resetDays() {
        this.resetFiles();
        return false;
    }
}

