/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.twoplanar3T;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TAddressFunction;
import org.maltparser.parser.algorithm.twoplanar3T.TwoPlanar3TConfig;

public abstract class TwoPlanar3TFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public TwoPlanar3TFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Two-Planar 3T with no_covered_roots = " + this.manager.getOptionValue("planar3tlab", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + this.manager.getOptionValue("planar3tlab", "acyclicity").toString().toUpperCase() + ", planar root handling = " + this.manager.getOptionValue("2planar3t", "planar_root_handling").toString().toUpperCase() + ", reduce on switch = " + this.manager.getOptionValue("2planar3t", "reduceonswitch").toString().toUpperCase() + ", reconstruction technique = " + this.manager.getOptionValue("2planar3t", "2reconstruction").toString() + ", heuristic = " + this.manager.getOptionValue("2planar3t", "2heuristic").toString() + "\n");
        }
        return new TwoPlanar3TConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("planar3tlab", "no_covered_roots").toString(), this.manager.getOptionValue("planar3tlab", "acyclicity").toString(), this.manager.getOptionValue("2planar3t", "reduceonswitch").toString(), this.manager.getOptionValue("2planar3t", "planar_root_handling").toString(), this.manager.getOptionValue("2planar3t", "2reconstruction").toString(), this.manager.getOptionValue("2planar3t", "2heuristic").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new TwoPlanar3TAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

