/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import java.util.Arrays;
import tsg.Constituency;
import tsg.TSNodeLabel;
import tsg.Yield;

public class ConstituencyYield
extends Constituency {
    Yield yield;

    public ConstituencyYield(TSNodeLabel node, Yield yield, boolean countLabel) {
        super(node, countLabel);
        this.yield = yield;
    }

    @Override
    public Constituency unlabeledCopy() {
        return new ConstituencyYield(this.node, this.yield, false);
    }

    public static ArrayList<Constituency> collectConsituencies(TSNodeLabel tree, boolean labeled, String[] excludeLabels, boolean includePos) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        ArrayList<TSNodeLabel> allNodes = tree.collectAllNodes();
        for (TSNodeLabel NT : allNodes) {
            if (NT.isLexical || NT.isPreLexical() && !includePos || Arrays.binarySearch(excludeLabels, NT.label()) >= 0) continue;
            result.add(new ConstituencyYield(NT, new Yield(NT.getYield()), labeled));
        }
        return result;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ConstituencyYield) {
            ConstituencyYield c = (ConstituencyYield)anObject;
            if ((!this.countLabel || c.node.sameLabel(this.node)) && c.yield.equals(this.yield)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.yield.hashCode();
    }

    public boolean equalsConst(Constituency anOtherConst, boolean labeled) {
        if (this == anOtherConst) {
            return true;
        }
        if (anOtherConst instanceof ConstituencyYield) {
            ConstituencyYield c = (ConstituencyYield)anOtherConst;
            if ((!labeled || c.node.sameLabel(this.node)) && c.yield.equals(this.yield)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "(" + this.node.label() + ": " + this.yield + ")";
    }
}

