/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import tsg.Constituency;
import tsg.ConstituencyYield;
import tsg.TSNodeLabel;
import tsg.Yield;
import util.Utility;

public class ConstituencyWords
extends Constituency {
    int initialIndex;
    int finalIndex;

    public ConstituencyWords(TSNodeLabel node, int initialIndex, int finalIndex, boolean countLabel) {
        super(node, countLabel);
        this.initialIndex = initialIndex;
        this.finalIndex = finalIndex;
    }

    public int getInitialIndex() {
        return this.initialIndex;
    }

    public int getFinalIndex() {
        return this.finalIndex;
    }

    @Override
    public Constituency unlabeledCopy() {
        return new ConstituencyWords(this.node, this.initialIndex, this.finalIndex, false);
    }

    public static ArrayList<ConstituencyWords> collectConsituencies(TSNodeLabel tree, boolean labeled, String[] excludeLabels, boolean includePos) {
        ArrayList<ConstituencyWords> result = new ArrayList<ConstituencyWords>();
        IdentityHashMap<TSNodeLabel, Integer> lexIntMapping = new IdentityHashMap<TSNodeLabel, Integer>();
        ArrayList<TSNodeLabel> lexLabels = tree.collectLexicalItems();
        int i = 0;
        for (TSNodeLabel l : lexLabels) {
            lexIntMapping.put(l, i++);
        }
        ArrayList<TSNodeLabel> allNodes = tree.collectAllNodes();
        for (TSNodeLabel NT : allNodes) {
            if (NT.isLexical || NT.isPreLexical() && !includePos || Arrays.binarySearch(excludeLabels, NT.label()) >= 0) continue;
            int start = (Integer)lexIntMapping.get(NT.getLeftmostLexicon());
            int end = (Integer)lexIntMapping.get(NT.getRightmostLexicon());
            result.add(new ConstituencyWords(NT, start, end, labeled));
        }
        return result;
    }

    public boolean isCrossing(ConstituencyWords c) {
        return this.initialIndex < c.initialIndex && this.finalIndex >= c.initialIndex && this.finalIndex < c.finalIndex || this.initialIndex > c.initialIndex && this.initialIndex <= c.finalIndex && this.finalIndex > c.finalIndex;
    }

    public static int updateCrossingBrackets(List<? extends Constituency> testConst, List<? extends Constituency> goldConst, Hashtable<String, Integer> crossingBracketsCatTable) {
        int result = 0;
        block0: for (Constituency constituency : testConst) {
            for (Constituency constituency2 : goldConst) {
                if (!((ConstituencyWords)constituency).isCrossing((ConstituencyWords)constituency2)) continue;
                ++result;
                if (crossingBracketsCatTable == null) continue block0;
                String key = String.valueOf(constituency.node.label()) + "/" + constituency2.node.label();
                Utility.increaseStringInteger(crossingBracketsCatTable, key, 1);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof ConstituencyWords) {
            ConstituencyWords c = (ConstituencyWords)anObject;
            if ((!this.countLabel || c.node.sameLabel(this.node)) && c.initialIndex == this.initialIndex && c.finalIndex == this.finalIndex) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.countLabel) {
            return 31 * (this.initialIndex + 31 * (this.finalIndex + 31 * this.label().hashCode()));
        }
        return 31 * (this.initialIndex + 31 * this.finalIndex);
    }

    public static ArrayList<Constituency> toYieldConstituency(ArrayList<Constituency> list, TSNodeLabel tree, boolean labeled) {
        ArrayList<Constituency> result = new ArrayList<Constituency>();
        ArrayList<TSNodeLabel> lexicon = tree.collectLexicalItems();
        for (Constituency C : list) {
            ConstituencyWords IC = (ConstituencyWords)C;
            List<TSNodeLabel> subLex = lexicon.subList(IC.initialIndex, IC.finalIndex + 1);
            String yield = "";
            for (TSNodeLabel lex : subLex) {
                yield = String.valueOf(yield) + lex + " ";
            }
            yield = yield.trim();
            result.add(new ConstituencyYield(IC.node, new Yield(yield), labeled));
        }
        return result;
    }

    public String toString() {
        return "(" + this.node.label() + ": " + this.initialIndex + "-" + this.finalIndex + ")";
    }
}

