/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.BitSet;

public abstract class NodeSetCollector {
    int maxLenght;

    public void setMaxLength(int maxLength) {
        this.maxLenght = maxLength;
    }

    public abstract Object clone();

    public abstract boolean add(BitSet var1);

    public boolean addDefaultBitSet(int defaultIndex) {
        return this.add(this.getDefaultBitSet(defaultIndex));
    }

    public abstract boolean addAll(NodeSetCollector var1);

    public abstract boolean addAllCombinations(NodeSetCollector[] var1, int[] var2, int var3);

    public abstract int size();

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract String toString();

    public abstract BitSet uniteSubGraphs();

    public abstract boolean removeSingleton(int var1);

    public abstract boolean removeUniqueSingleton();

    public abstract BitSet[] getBitSetsAsArray();

    public abstract int maxCardinality();

    public abstract void makeEmpty();

    public BitSet getDefaultBitSet(int setIndex) {
        BitSet bs = new BitSet(this.maxLenght);
        bs.set(setIndex);
        return bs;
    }

    public static boolean includes(BitSet A, BitSet B) {
        BitSet intersection = (BitSet)A.clone();
        intersection.and(B);
        return intersection.cardinality() == B.cardinality();
    }
}

