
[ROLE]
You are expert in extracting relevant and concise information from any user query. 
---
[INPUT]
You will be given `query` along with desired `test cases`. This `query` is a command for generating a python code function. The desired `test cases` is used to test for given input output pairs from user to check for the intended code.
---
[TASK]
You need to extract all relevant information from the `query` and `test cases`, and store in structured JSON format. For completing the getting all information, extract in the form of these BUCKETS:-
[BUCKETS]
1. "task": Extract main/prime task to be performed in the function. It has be derived essence and not always word by word extracted.
2. "method": Extract list of any specific method/technique/using/algorithm mentioned to get to result
3. "input_type": Extract the list of all input data types to function if explicitly mentioned
4. "input_property": Extract all list of extra conditions/parameters/properties regarding the input e.g. starting/ending point, condition/criteria applied, property of input like length, shape, size, number, largeness, order, large/small/top... These can be adjectives to input_type, numerics, or arguments associated to input for function
5. "output_type": Extract the list of all output data type returned by function if explicitly mentioned
6. "output_property": Extract all list of extra conditions/parameters/properties regarding the output e.g. odd/even, condition/criteria applied, property of input like length, shape, size, number, largeness, order... These can be adjectives to output_type, numerics, or arguments associated to output for function
7. "edge_cases": Extract the dictionary of all edge/critical condition and response if explicitly mentioned
- Each key value should be explicitly word-by-word extracted from `query`, explicitly mentioned and traceable back to the `query`. They should NOT be derive/understanding knowledge.
- Return response in JSON format template:
{"task": "...", "method": [...], "input_type": [...], "input_property": [...], "output_type": [...], "output_property": [...], "edge_cases": {...}}
---

`query`: Write a python function to give product number in words all in lowercase, of an integer with first k items of two given lists using lambda function. If any list is empty, return '-'.
`test cases`: ["assert product(1, [1, 2, 3, 4, 5], 1) == 'one'", 
    "assert product(3, [3, 6, 7], 2) == 'fifty four'", 
    "assert product(9, [], 3) == '-'"]
`info`: {"task": "product", "method": ["lambda function"], "input_type": ["integer","two lists"], "input_property": ["first k"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
---

`query`: Write a function to return ascending sort on descending sorted list.
`test cases`: ["assert desc_sort([5, 4, 3, 2, 1]) == [1, 2, 3, 4, 5]", 
    "assert desc_sort([7, 6, 3]) == [3, 6, 7]"]
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["descending", "sorted"], "output_type": ["list"], "output_property": ["ascending"], "edge_cases": {}}
---

`query`: Write a function to find largest number from a list.
`test cases`: ["assert largest_num([10, 4, 1, 7, 9]) == 10",
            "assert largest_num([0]) == 0",
            "assert largest_num([3, 9, 8]) == 9"]
`info`: {"task": "find", "method": [], "input_type": ["list"], "input_property": [], "output_type": ["number"], "output_property": ["largest"], "edge_cases": {}}
---

`query`: Check if input is even.
`test cases`: ["assert is_even(4) == 'Even'",
            "assert is_even(-3) == 'Not Even'"]
`info`: {"task": "check", "method": [], "input_type": ["number"], "input_property": [], "output_type": ["specific string"], "output_property": ["even"], "edge_cases": {"if True": "Even", "if False": "Not Even"}}
---

`query`: Return strings with words longer.
`test cases`: ["assert filter_longer(['aabc', 'a', 'jhgfu']) == ['aabc', 'jhgfu']"
            "assert filter_longer(['a', 'ok']) == []",
            "assert filter_longer(['aabc', 'kjh', 'jhgfu']) == ['aabc', 'kjh', 'jhgfu']"]
`info`: {"task": "filter", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["list of strings"], "output_property": ["longer than 2"], "edge_cases": {}}

---

`query`: Find the maximum length of string.
`test cases`: ["assert filter_longer(['aabc', 'a', 'jhgfu']) == 4"
            "assert filter_longer(['a', 'ok']) == 2",
            "assert filter_longer(['']) == 0",
            "assert filter_longer([]) == -1"]
`info`: {"task": "return", "method": [], "input_type": ["list of strings"], "input_property": [], "output_type": ["number"], "output_property": ["maximum length"], "edge_cases": {"if empty list": "-1"}}
---

`query`: {{originalNL}}
`test cases`: {{test cases}}
`info`: 