#!/bin/bash

# set -ex

# These use the Bertscore configuration

# alpha = discriminator
# beta = ???
# delta = hamming
# gamma = bleurt score
# theta = bert score

SHARD='test' # 'test' or 'val'

INFORMAL_DATA="../..//gyafc/data/GYAFC_Corpus 2/Entertainment_Music/test/informal"
FORMAL_DATA='../..//gyafc/data/GYAFC_Corpus 2/Entertainment_Music/test/formal_for_timing.txt'
#"../..//gyafc/data/GYAFC_Corpus 2/Entertainment_Music/test/formal"


INTERNAL_MODEL='/mnt/emnlp_formality/models/roberta-base/roberta-base_5e-05_128_Entertainment_Music_train_formal-Entertainment_Music_train_informal/42/2024-05-19-19_53_30/checkpoint-1200'

# # Informal to Formal (Discriminator)
# CUDA_VISIBLE_DEVICES=0 python sample_batched_form_em_len_enron.py \
# --batch_size 20 \
# --n_samples 20 \
# --max_iter 5 \
# --shuffle_positions \
# --temperature 1.0 \
# --out_path ./output_samples/formality/enron_neg_to_pos_DISC \
# --alpha 140  \
# --beta 1 \
# --delta 15 \
# --gamma 0 \
# --theta 100 \
# --data_path "$INFORMAL_DATA" \
# --data_name "${SHARD}_neg" \
# --disc_name $INTERNAL_MODEL \
# --target_label formal \
# --disc_dir $INTERNAL_MODEL &

# # # Informal to Formal (Hamming)
# CUDA_VISIBLE_DEVICES=1 python sample_batched_form_em_len_enron.py \
# --batch_size 20 \
# --n_samples 20 \
# --max_iter 5 \
# --shuffle_positions \
# --temperature 1.0 \
# --out_path ./output_samples/formality/enron_neg_to_pos_HAM \
# --alpha 140  \
# --beta 1 \
# --delta 50 \
# --gamma 0 \
# --theta 300 \
# --data_path "$INFORMAL_DATA" \
# --data_name "${SHARD}_neg" \
# --disc_name $INTERNAL_MODEL \
# --target_label formal \
# --disc_dir $INTERNAL_MODEL &

# # Formal to Informal (Discriminator)
CUDA_VISIBLE_DEVICES=3 python sample_batched_form_em_len_enron.py \
--batch_size 20 \
--n_samples 20 \
--max_iter 5 \
--shuffle_positions \
--temperature 1.0 \
--out_path ./output_samples/formality_timing/enron_pos_to_neg_DISC \
--alpha 140  \
--beta 1 \
--delta 15 \
--gamma 0 \
--theta 100 \
--data_path "$FORMAL_DATA" \
--data_name "${SHARD}_pos" \
--disc_name $INTERNAL_MODEL \
--target_label informal \
--disc_dir $INTERNAL_MODEL &

# Formal to Informal (Hamming)
# CUDA_VISIBLE_DEVICES=3 python sample_batched_form_em_len_enron.py \
# --batch_size 20 \
# --n_samples 20 \
# --max_iter 5 \
# --shuffle_positions \
# --temperature 1.0 \
# --out_path ./output_samples/formality_timing/enron_pos_to_neg_HAM \
# --alpha 140  \
# --beta 1 \
# --delta 50 \
# --gamma 0 \
# --theta 300 \
# --data_path "$FORMAL_DATA" \
# --data_name "${SHARD}_pos" \
# --disc_name $INTERNAL_MODEL \
# --target_label informal \
# --disc_dir $INTERNAL_MODEL &
