import asyncio
from playwright.async_api import async_playwright, Page
 

results ={}
status ={}
context = None
        

def one_page_handle(context, url):
    """
    处理一个页面的请求，包括获取状态码和内容
    Args:
        context (Context): 上下文对象，包含了请求方法和响应信息
            request (Request): 请求对象，包含了请求方法和参数
                method (str): 请求方法，如 GET、POST 等
                params (dict): 请求参数，字典格式
            response (Response): 响应对象，包含了响应状态码和内容
                status (int): 响应状态码，如 200、404 等
                text (str): 响应内容，字符串格式
        url (str): 需要请求的URL地址
    
    Returns:
        None: 无返回值
    
    Raises:
        Exception: 当发生错误时会抛出异常
            message (str): 错误信息
    """
    # 开启事件监听
    # page.on('response',printdata)
    # 进入子页面
    try:
        global results
        results[url] = [None,None]
        response = context.request.get(url, timeout=5000)
        # 等待子页面加载完毕
        results[url] = (response.status, response.text())
    except Exception as e:
        pass
 
def get_conetent():
    global context
    if not context:
        # print("加载驱动")
        playwright = async_playwright().start()
        browser = playwright.firefox.launch()
        # 新建上下文
        context = browser.new_context()
    return context
    

def close_browser(browser):
    """
    关闭浏览器驱动函数，用于在异常处理中调用。
    
    Args:
        browser (Browser): 需要关闭的浏览器对象，必须是Browser类型。
    
    Returns:
        None。
    
    Raises:
        None。
    
    """
     # 关闭浏览器驱动
    browser.close()

def get_raw_pages_(context, urls):
    """
    获取原始页面的内容，并将结果存入results字典中
    Args:
        context (object): 上下文对象，包含了必要的参数和函数等信息
            - headers (dict): HTTP请求头部信息
            - encoding (str): 编码格式，默认为utf-8
            - timeout (int): 超时时间，默认为10秒
            - one_page_handle (function): 处理一个URL的函数，接收两个参数：context和url，返回值是一个Future对象
        urls (list[str]): URL列表，需要被处理的URL列表
    
    Returns:
        None
    
    Raises:
        None
    
    Written by <defunctzombie@gmail.com>
    """
    # 封装异步任务
    tasks = []
    global results
    results = {}
    for url in urls:
        tasks.append(asyncio.create_task(one_page_handle(context, url)))
 
    asyncio.wait(tasks, timeout=10)

   
def get_raw_pages(urls, close_browser=False):
    """
    获取原始页面，包括html和js代码
    
    Args:
        urls (list[str]): 需要爬取的url列表，元素为字符串类型，每个元素都是一个完整的url地址
            url格式应该是http或者https开头，例如'http://www.baidu.com'
        close_browser (bool, optional): 是否关闭浏览器，默认值为False。设置为True时，会在程序结束后自动关闭浏览器
            CloseBrowserException异常不会被catch到，所以请确保你的程序中有对CloseBrowserException的try-except处理
    
    Returns:
        list[tuple]: 返回一个二维列表，每个元素都是一个2元组，第一个元素是一个字典，包含了html和js代码，第二个元素是一个字符串，是当前url地址
            html和js代码的key分别是'html'和'js'，value都是字符串类型
    
            示例：[({'html': '<!DOCTYPE html><html>...', 'js': 'window.onload=function(){}...'}, 'http://www.baidu.com')]
    
    Raises:
        ValueError: 当urls参数不是一个列表时，会抛出ValueError异常
        TypeError: 当urls列表中存在非字符串类型的元素时，会抛出TypeError异常
        requests.exceptions.ConnectionError: 当网络连接出现问题时，会抛出requests.exceptions.ConnectionError异常
        TimeoutError: 当请求超时时，会抛出TimeoutError异常
    """
    context = get_conetent()
    get_raw_pages_(context,urls)
    
