
# prefix-16
# server environment
  base_dir="/main/path"

  data_dir="${base_dir}/VQA/features"
  output_path="${base_dir}/trained_output/oscar/"
  oscar_base_model_path="${base_dir}/PGF/OSCAR_Pretrained_for_VQA/base"

# output
  model_path="${output_path}/wandb/latest-run/files/best"
  eval_output_path="${output_path}/wandb/latest-run/files"

# input
  train_yaml="${data_dir}/train/train.yaml"
  test_yaml="${data_dir}/test/test-dev.yaml"
  val_yaml="${data_dir}/val/val.yaml"
  label2ans_file="${data_dir}/trainval_label2ans.pkl"
  ans2label_file="${data_dir}/trainval_ans2label.pkl"

  seed=88
  random_id=$(cat /dev/urandom | tr -dc 'A-Z' | fold -w 2 | sed 1q)

  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --name "oscar_train+val_seed_${seed}_id_${random_id}" \
  --scheduler "linear" \
  --learning_rate 5e-05 \
  --cls_hidden_scale 3 \
  --per_gpu_train_batch_size 16 \
  --classifier linear \
  --seed ${seed} \
  --model_name_or_path ${oscar_base_model_path} \
  --output_dir ${output_path} \
#  --freeze_embedding True \

  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --do_train False \
  --do_test True \
  --eval_model_dir ${model_path} \
  --output_dir ${eval_output_path}
