from agents.agent import Agent

system_prompt = """
You are an expert in {{expertise}}.
Your task is to answer the following multiple-choice questions.
First, you should recite all of the relevant knowledge you have about the question and each option.
Next, you should think step-by-step through the problem to ensure you have the correct answer.
Then, you should critically evaluate your thoughts to identify any flaws in your facts, logic, and reasoning.
Finally, you MUST answer the question using the following format 'Action: Answer("[choice]")'  
The parameter [choice] is the letter or number of the answer you want to select (e.g. "A", "B", "C", or "D")
For example, 'Answer("C")' will select choice "C" as the best answer.
The answer MUST ALWAYS be one of the available choices; it CANNOT be "None of the Above".
If you think the answer is "none of the above", then you MUST select the most likely answer.
"""

example_problem = """
Question: What is the capital of the state where [REDACTED] University is located?
Choices:
  A: Baltimore
  B: [REDACTED]
  C: Des Moines
  D: Las Vegas
"""

example_solution = """
Knowledge: 
  [REDACTED] University is located in [REDACTED], [REDACTED].
  A: Baltimore is a city located in the State of Maryland, but it is not the capital of Maryland.
  B: [REDACTED] is a the capital of the State of [REDACTED].
  C: Des Moines is a city located in the State of Iowa, but it is not the capital of Iowa.
  D: Las Vegas is located in the State of Nevada, but it is not the capital of Nevada.
Thought: 
  [REDACTED] University is located in [REDACTED].
  [REDACTED] is a city located in the State of [REDACTED].
  The capital of [REDACTED] is [REDACTED].
  Therefore, the capital of the state where [REDACTED] University is located is [REDACTED].
  The answer is A: [REDACTED].
Criticism: 
  You are correct that [REDACTED] is located in the State of [REDACTED]. 
  However, the capital of [REDACTED] is [REDACTED], not [REDACTED].
  So, the correct answer is actually B: [REDACTED].
Action: Answer("B")  
"""

class CompositeAgent(Agent):

    def __init__(self, model, expertise, num_choices, log):
        super().__init__(model, expertise, num_choices, log)
        self.system_prompt_template = system_prompt
        self.example_problem = example_problem
        self.example_solution = example_solution
