export TASK_NAME=qqp
export CUDA_VISIBLE_DEVICES=0

python run_glue.py \
  --model_name_or_path microsoft/deberta-v3-base \
  --task_name $TASK_NAME \
  --learning_rate 6e-4 \
  --num_train_epochs 10 \
  --warmup_steps 0 \
  --apply_lora \
  --lora_dropout 0.05 \
  --prilora_exp prilora \
  --prilora_prune 0.50 \
  --lin_start 4 \
  --lin_stop 12 \
  --weight_decay 0.01 \
  --per_device_train_batch_size 32 \
  --per_device_eval_batch_size 8 \
  --set_seed 42 \
  --eval_steps 500 \
  --do_train \
  --do_eval \
  --max_seq_length 128 \
  --metric_for_best_model eval_accuracy \
  --evaluation_strategy steps \
  --save_total_limit 2 \
  --save_strategy no \
  --logging_steps 125 \
  --report_to wandb \
  --output_dir /tmp/$TASK_NAME




