import random

import autocuda

from LSA.functional import Trainer
from LSA.functional import APCConfigManager
from LSA.functional import ABSADatasetList
from LSA.functional import APCModelList

import warnings

warnings.filterwarnings('ignore')

seeds = [random.randint(0, 10000) for _ in range(1)]
device = autocuda.auto_cuda()

for dataset in [
    ABSADatasetList.Laptop14,
    ABSADatasetList.Restaurant14,
    ABSADatasetList.MAMS,
    ABSADatasetList.ACL_Twitter
]:
    config = APCConfigManager.get_apc_config_english()
    config.model = APCModelList.FAST_LSA_T_V2  # LSA-T
    config.lcf = 'cdw'
    config.similarity_threshold = 1
    config.max_seq_len = 80
    config.dropout = 0
    config.optimizer = 'adamw'
    config.cache_dataset = False
    config.patience = 5
    config.pretrained_bert = 'microsoft/deberta-v3-base'
    config.num_epoch = 3
    config.log_step = 5
    config.SRD = 3
    config.lsa = True
    config.eta = 0.5
    config.learning_rate = 2e-5
    config.batch_size = 16
    config.evaluate_begin = 2
    config.l2reg = 1e-5
    config.seed = seeds

    inference_model = Trainer(config=config,
                              dataset=dataset,
                              checkpoint_save_mode=0,
                              auto_device=device
                              ).load_trained_model()

for dataset in [
    ABSADatasetList.Laptop14,
    ABSADatasetList.Restaurant14,
    ABSADatasetList.MAMS,
    ABSADatasetList.ACL_Twitter
]:
    config = APCConfigManager.get_apc_config_english()
    config.model = APCModelList.FAST_LSA_S_V2  # LSA-S
    config.lcf = 'cdw'
    config.similarity_threshold = 1
    config.max_seq_len = 80
    config.dropout = 0
    config.optimizer = 'adamw'
    config.cache_dataset = False
    config.patience = 5
    config.pretrained_bert = 'microsoft/deberta-v3-base'
    config.num_epoch = 3
    config.log_step = 5
    config.SRD = 3
    config.lsa = True
    config.eta = 0.5
    config.learning_rate = 2e-5
    config.batch_size = 16
    config.evaluate_begin = 2
    config.l2reg = 1e-5
    config.seed = seeds

    inference_model = Trainer(config=config,
                              dataset=dataset,
                              checkpoint_save_mode=0,
                              auto_device=device
                              ).load_trained_model()

for dataset in [
    ABSADatasetList.Laptop14,
    ABSADatasetList.Restaurant14,
    ABSADatasetList.MAMS,
    ABSADatasetList.ACL_Twitter
]:
    config = APCConfigManager.get_apc_config_english()
    config.model = APCModelList.LSA_P_V2  # LSA-P
    config.lcf = 'cdw'
    config.similarity_threshold = 1
    config.max_seq_len = 80
    config.dropout = 0
    config.optimizer = 'adamw'
    config.cache_dataset = False
    config.patience = 5
    config.pretrained_bert = 'microsoft/deberta-v3-base'
    config.num_epoch = 3
    config.log_step = 5
    config.SRD = 3
    config.lsa = True
    config.eta = 0.5
    config.learning_rate = 2e-5
    config.batch_size = 16
    config.evaluate_begin = 2
    config.l2reg = 1e-5
    config.seed = seeds

    inference_model = Trainer(config=config,
                              dataset=dataset,
                              checkpoint_save_mode=0,
                              auto_device=device
                              ).load_trained_model()

