theory question_61_3

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  CentralBody :: "entity ⇒ entity ⇒ bool"
  SolarSystem :: "entity"
  SolarSystemBody :: "entity ⇒ bool"

(* Explanation 1: The sun is a star and it is the central body in the solar system. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x ∧ CentralBody x SolarSystem"

(* Explanation 2: The solar system consists of all solar system bodies. *)
axiomatization where
  explanation_2: "∀x. SolarSystemBody x ⟶ x = SolarSystem ∨ CentralBody x SolarSystem"

theorem hypothesis:
  assumes asm: "SolarSystemBody x"
  (* Hypothesis: The largest body in the solar system is the sun. *)
  shows "Sun x"
proof -
  from asm have "x = SolarSystem ∨ CentralBody x SolarSystem" using explanation_2 by blast
  then have "Star x ∨ CentralBody x SolarSystem" by simp
  then have "Sun x" using explanation_1 by blast
  then show "Sun x" by simp
qed

end
