theory question_63_6
imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  Includes :: "entity ⇒ entity ⇒ bool"
  Rocks :: "entity ⇒ bool"
  FormedByDeposition :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation: Sedimentary rocks include sandstone, which is formed by deposition. *)
axiomatization where
  explanation: "∀x y. SedimentaryRocks x ∧ Includes x y ∧ FormedByDeposition z ∧ Agent z y ⟶ Sandstone y"

theorem hypothesis:
  assumes asm: "Rocks x ∧ FormedByDeposition y ∧ Agent y x"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x" by simp
  then have "SedimentaryRocks x \/ (Rocks x ∧ ¬ SedimentaryRocks x)" by simp
  then have "SedimentaryRocks x"
    by (rule classical_on_sets [where P="SedimentaryRocks"])
  then have "Includes x sandstone" by (rule explanation) auto
  then have "Sandstone sandstone" by (rule includes_def)
  then show "Sandstone x" by simp
qed

end
