theory question_96_7
imports Main

begin

typedecl entity
typedecl event

consts
  Child :: "entity ⇒ bool"
  Adult :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  swim :: "entity ⇒ event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Member :: "entity ⇒ entity ⇒ bool"
  Group :: "entity ⇒ bool"
  g :: "entity"
  x :: "entity"
  e :: "event"

(* Explanation 3: If the pool is open, then some child or adult is swimming in the pool. *)
axiomatization where
  explanation_3: "∀e. Pool e ⟶ (∃x. (Child x ∨ Adult x) ∧ swim x e ∧ In x e)"

theorem hypothesis:
  (* Premise: There is a group g of people, and every member of g is swimming in the pool. *)
  assumes asm: "Group g ∧  Member x g ∧  swim x e ∧ Agent e x ∧ In x  Pool e   "
  (* Hypothesis: Some child or adult is swimming in the pool. *)
  shows "∃x.  Child x ∨ Adult x  ∧  swim x e ∧ Agent e x ∧ In x  Pool e  "
proof -
  from asm have "Group g" by blast
  then have "∃x. Member x g" by blast
  then obtain x where "Member x g" using blast
  with asm have "swim x e ∧ Agent e x ∧ In x Pool e" by blast
  then have "Child x ∨ Adult x" by blast
  then show "∃x.  Child x ∨ Adult x  ∧  swim x e ∧ Agent e x ∧ In x Pool e" using asm by blast
qed

end
