theory question_19_9

imports Main

begin
typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  PurpleSweater :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  OddLook :: "entity ⇒ bool"
  OddLookAssociatedWith :: "entity ⇒ bool"

(* Explanation 1: If a person has an odd look, then any entity worn by the person also has an odd look associated with it. *)
axiomatization where
  explanation_1: "∀x z. OddLook x ∧ Wearing x z ⟶ OddLookAssociatedWith z"

theorem hypothesis:
  (* Hypothesis: A woman in a purple sweater has an odd look on her face. *)
  assumes asm:
  shows "∃x y. Woman x ∧ PurpleSweater y ∧ Wearing x y ∧ OddLook x"
proof -
  from asm have "Woman x ∧ PurpleSweater y ∧ Wearing x y ∧ OddLook x" by blast
  then have "OddLookAssociatedWith y" using explanation_1 by blast
  show ?thesis using asm by blast
qed

end
