theory question_80_8

imports Main

begin

typedecl entity
typedecl event

consts
  Copper :: "entity ⇒ bool"
  ConductsElectricity :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"

(* Explanation 1: Copper is a material that conducts electricity. *)
axiomatization where
  explanation_1: "∃x. Copper x ∧ ConductsElectricity x"

(* Explanation 2: Some materials are electrical conductors. *)
axiomatization where
  explanation_2: "∃x. Material x ∧ ElectricalConductor x"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Material x ∧ ElectricalConductor x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ∧ ConductsElectricity x"
proof -
  from asm have "Material x ∧ ElectricalConductor x" by simp
  then obtain e1 where e1: "Copper x ∧ ConductsElectricity x" using explanation_1 by blast
  have conclusion: "Copper x ∧ ConductsElectricity x" using e1 by simp
  show ?thesis using asm conclusion by auto
qed

end
