theory question_18_0

imports Main

begin

typedecl entity
typedecl event
consts
  Competition :: "entity ⇒ bool"
  JavelinCompetition :: "entity ⇒ bool"
  Competing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: There must be a competition for a Javelin competition to take place. *)
axiomatization where
  explanation_1: "∀x e. Competition x ⟶ JavelinCompetition x ∧ Competing e ∧ Agent e x"

theorem hypothesis:
  (* Premise: Javelin competition *)
  assumes asm: "JavelinCompetition x ∧ Competing e ∧ Agent e x"
  (* Hypothesis: There is a competition. *)
  shows "∃x e. Competition x ∧ Competing e ∧ Agent e x"
proof -
  from asm have "JavelinCompetition x ∧ Competing e ∧ Agent e x" by blast
  then have "∃x e. Competition x ∧ Competing e ∧ Agent e x" using explanation_1 by blast
  show ?thesis using `JavelinCompetition x` `Competing e` `Agent e x` by blast
qed

end
