theory question_85_3

imports Main

begin
typedecl entity

consts
  Vendor :: "entity ⇒ bool"
  FlowerCart :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  FlowerSellerOnSidewalk :: "entity ⇒ bool"

(* Explanation 1: A vendor with a flower cart on the sidewalk is a flower seller on the sidewalk. *)
axiomatization where
  explanation_1: "∀x y z. Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ With x y ∧ On x z ⟶ FlowerSellerOnSidewalk x"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ On x z ∧ With x y"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y. FlowerSeller x ∧ Sidewalk y ∧ On x y"
proof -
  from asm have "Vendor x ∧ FlowerCart y ∧ Sidewalk z ∧ On x z ∧ With x y" by blast
  then have "FlowerSellerOnSidewalk x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
