#!/usr/bin/env bash

# bash generate_zero.sh mspm2 en fr finetune_mspm2_shareEmb_freezeEmbDecoder

DATAVER="$1"
TRAIN_LG="$2"
TEST_LG="$3"
NAME="$4"

argslist=""
for (( i = 5; i <= $# ; i++ ))
  do
    j=${!i}
    argslist="${argslist} $j "
  done
echo $argslist >&2

cd "$(dirname $0)" || return

echo "Install fairseq" >&2

pip3 install -e fairseq -i http://pypi.byted.org/simple/ --trusted-host=pypi.byted.org
pip3 install -r requirements.txt -i http://pypi.byted.org/simple/ --trusted-host=pypi.byted.org

# sudo apt-get update
# sudo apt-get install libxml-perl libxml-dom-perl

export PYROUGE_HOME_DIR=$(pwd)/RELEASE-1.5.5
export PYROUGE_TEMP_PATH=/opt/tiger

pyrouge_set_rouge_path $PYROUGE_HOME_DIR
chmod +x $PYROUGE_HOME_DIR/ROUGE-1.5.5.pl

prefix=hdfs://haruna/home/byte_arnold_lq_mlnlc/user/wangdanqing.122
wxz_prefix=hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0

dataset_path=${prefix}/Datasets/multilingual/data-bin/${DATAVER}/${TEST_LG}
tensorboard_logdir=${wxz_prefix}/Workspace/Multilingual/${TEST_LG}/logs/${NAME}_${TRAIN_LG}
checkpoint_path=${wxz_prefix}/Workspace/Multilingual/${TRAIN_LG}/checkpoints/${NAME}

# change checkpoint path
hdfs dfs -mkdir -p $tensorboard_logdir

local_root=~/zeroshot_${NAME}_${TEST_LG}
resource_root=${local_root}/resource
output_path=${local_root}/output
model_path=${local_root}/model
mkdir -p ${resource_root}
mkdir -p ${output_path}
mkdir -p ${model_path}

local_dataset_path=${resource_root}/dataset
mkdir -p ${local_dataset_path}
hadoop fs -copyToLocal ${dataset_path}/* ${local_dataset_path}
echo "Download resource from ${dataset_path} to ${local_dataset_path}" >&2

local_tensorboard_path=${output_path}/tensorboard_logdir
#hadoop fs -copyToLocal ${tensorboard_logdir} ${local_tensorboard_path}
mkdir -p ${local_tensorboard_path}

local_checkpoint_path=${output_path}/checkpoint_path
mkdir -p ${local_checkpoint_path}
hadoop fs -copyToLocal ${checkpoint_path}/checkpoint_best.pt ${local_checkpoint_path}
hadoop fs -copyToLocal ${checkpoint_path}/checkpoint_last.pt ${local_checkpoint_path}
echo "Load checkpoints from ${checkpoint_path}/checkpoint_best.pt to ${local_checkpoint_path}" >&2
echo "Load checkpoints from ${checkpoint_path}/checkpoint_last.pt to ${local_checkpoint_path}" >&2

echo "Finish download files" >&2

langs=ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN

echo "Generating..."

suffix=$(echo "$argslist" | sed -e "s/-//g"  -e "s/  */_/g")

python3 fairseq/generate.py ${local_dataset_path}  \
--path ${local_checkpoint_path}/checkpoint_best.pt \
--task summarization_from_pretrained_wo_langtag \
--gen-subset test \
--source-lang doc --target-lang sum \
--langs $langs \
--remove-bpe 'sentencepiece'  \
--min-len 30 \
--max-len-b 50 \
--lenpen 0.6 \
--no-repeat-ngram-size 3 \
--truncate-source \
--user-dir examples/summarization \
$argslist \
> ${local_tensorboard_path}/"output$suffix"

cat ${local_tensorboard_path}/"output$suffix" | grep -P "^H" | sort -V |cut -f 3- | sed -e  "s/\[[a-z]\{2\}_[A-Z]\{2\}\]//g" > ${local_tensorboard_path}/"test$suffix.hypo"


echo "Load ground truth file from ${prefix}/Datasets/multilingual/clean0712/${TEST_LG}/test.${TEST_LG}.sum"
hadoop fs -get ${prefix}/Datasets/multilingual/clean0702/${TEST_LG}/test.${TEST_LG}.sum ${local_dataset_path}
hadoop fs -get ${prefix}/Datasets/multilingual/clean0712/${TEST_LG}/test.${TEST_LG}.sum ${local_dataset_path}

python3 utils/calRouge.py \
-c ${local_tensorboard_path}/"test$suffix.hypo" \
-r ${local_dataset_path}/test.${TEST_LG}.sum \
-l ${TEST_LG} -d "<q>"


echo "Put ${local_tensorboard_path} to ${tensorboard_logdir}" >&2
hadoop fs -put -f ${local_tensorboard_path}/* ${tensorboard_logdir}/
sleep 600
