import torch.nn as nn

class LinearClassifier(nn.Module):
    def __init__(self, input_dim):
        super().__init__()
        layers = []
        layers.append(nn.Linear(input_dim, 1, bias=False))
        self.layers = nn.ModuleList(layers)

    def forward(self, x):
        for layer in self.layers:
            x = layer(x)
        x = x.squeeze(-1)
        return x
